/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptedDataEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.EncryptionTypeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.HostAddressesEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.KerberosTimeEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.PrincipalNameEncoder;
import org.apache.directory.server.kerberos.shared.io.encoder.TicketEncoder;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.value.PaData;
import org.apache.directory.server.kerberos.shared.messages.value.RequestBody;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DERBitString;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class KdcRequestEncoder {
    public void encode(KdcRequest request, ByteBuffer out) throws IOException {
        ASN1OutputStream aos = new ASN1OutputStream(out);
        DERSequence kdcRequest = this.encodeInitialSequence(request);
        aos.writeObject(DERApplicationSpecific.valueOf(request.getMessageType().getOrdinal(), kdcRequest));
        aos.close();
    }

    private DERSequence encodeInitialSequence(KdcRequest app) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(1, DERInteger.valueOf(app.getProtocolVersionNumber())));
        sequence.add(new DERTaggedObject(2, DERInteger.valueOf(app.getMessageType().getOrdinal())));
        if (app.getPreAuthData() != null) {
            sequence.add(new DERTaggedObject(3, this.encodePreAuthData(app.getPreAuthData())));
        }
        sequence.add(new DERTaggedObject(4, this.encodeKdcRequestBody(app.getRequestBody())));
        return sequence;
    }

    public byte[] encodeRequestBody(RequestBody requestBody) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        aos.writeObject(this.encodeKdcRequestBody(requestBody));
        aos.close();
        return baos.toByteArray();
    }

    private DERSequence encodeKdcRequestBody(RequestBody requestBody) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, new DERBitString(requestBody.getKdcOptions().getBytes())));
        if (requestBody.getClientPrincipal() != null) {
            sequence.add(new DERTaggedObject(1, PrincipalNameEncoder.encode(requestBody.getClientPrincipal())));
        }
        sequence.add(new DERTaggedObject(2, DERGeneralString.valueOf(requestBody.getServerPrincipal().getRealm().toString())));
        if (requestBody.getServerPrincipal() != null) {
            sequence.add(new DERTaggedObject(3, PrincipalNameEncoder.encode(requestBody.getServerPrincipal())));
        }
        if (requestBody.getFrom() != null) {
            sequence.add(new DERTaggedObject(4, KerberosTimeEncoder.encode(requestBody.getFrom())));
        }
        sequence.add(new DERTaggedObject(5, KerberosTimeEncoder.encode(requestBody.getTill())));
        if (requestBody.getRtime() != null) {
            sequence.add(new DERTaggedObject(6, KerberosTimeEncoder.encode(requestBody.getRtime())));
        }
        sequence.add(new DERTaggedObject(7, DERInteger.valueOf(requestBody.getNonce())));
        sequence.add(new DERTaggedObject(8, EncryptionTypeEncoder.encode(requestBody.getEType())));
        if (requestBody.getAddresses() != null) {
            sequence.add(new DERTaggedObject(9, HostAddressesEncoder.encodeSequence(requestBody.getAddresses())));
        }
        if (requestBody.getEncAuthorizationData() != null) {
            sequence.add(new DERTaggedObject(10, EncryptedDataEncoder.encodeSequence(requestBody.getEncAuthorizationData())));
        }
        if (requestBody.getAdditionalTickets() != null) {
            sequence.add(new DERTaggedObject(11, TicketEncoder.encodeSequence(requestBody.getAdditionalTickets())));
        }
        return sequence;
    }

    private DERSequence encodePreAuthData(PaData[] preAuthData) {
        DERSequence preAuth = new DERSequence();
        for (int ii = 0; ii < preAuthData.length; ++ii) {
            DERSequence sequence = new DERSequence();
            sequence.add(new DERTaggedObject(1, DERInteger.valueOf(preAuthData[ii].getPaDataType().getOrdinal())));
            sequence.add(new DERTaggedObject(2, new DEROctetString(preAuthData[ii].getPaDataValue())));
            preAuth.add(sequence);
        }
        return preAuth;
    }
}

