/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.primitives;

import java.io.Serializable;
import org.apache.directory.shared.i18n.I18n;

public class BitString
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BitString EMPTY_STRING = new BitString(1);
    public static final boolean STREAMED = true;
    private static final int DEFAULT_LENGTH = 1024;
    private int nbUnusedBits;
    private boolean isStreamed;
    private byte[] bytes;
    private int nbBytes;
    private int nbBits;

    public BitString(int length) {
        if (length <= 0) {
            throw new IndexOutOfBoundsException(I18n.err("ERR_00029", new Object[0]));
        }
        this.nbBits = length;
        this.nbBytes = length / 8 + (length % 8 != 0 ? 1 : 0);
        this.nbUnusedBits = (8 - length % 8) % 8;
        if (this.nbBytes > 1024) {
            this.isStreamed = true;
            this.bytes = new byte[this.nbBytes];
        } else {
            this.isStreamed = false;
            this.bytes = new byte[this.nbBytes];
        }
    }

    public BitString(int length, boolean isStreamed) {
        if (length <= 0) {
            throw new IndexOutOfBoundsException(I18n.err("ERR_00029", new Object[0]));
        }
        this.nbBits = length;
        this.isStreamed = isStreamed;
        this.nbBytes = length / 8 + (length % 8 != 0 ? 1 : 0);
        this.nbUnusedBits = length % 8;
        this.bytes = isStreamed ? new byte[this.nbBytes] : new byte[this.nbBytes];
    }

    public BitString(byte[] bytes) {
        this.nbBytes = bytes.length - 1;
        if (this.nbBytes > 1024) {
            this.isStreamed = true;
            this.bytes = new byte[this.nbBytes];
        } else {
            this.isStreamed = false;
            this.bytes = new byte[this.nbBytes];
        }
        this.setBytes(bytes, this.nbBytes);
    }

    private void setBytes(byte[] bytes, int nbBytes) {
        this.nbUnusedBits = bytes[0] & 7;
        this.nbBits = nbBytes * 8 - this.nbUnusedBits;
        for (int i = 0; i < nbBytes; ++i) {
            this.bytes[i] = bytes[i + 1];
        }
    }

    public void setData(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            this.nbBits = -1;
            return;
        }
        int nbb = bytes.length - 1;
        if (nbb > 1024 && bytes.length < nbb) {
            bytes = new byte[nbb];
        }
        this.setBytes(bytes, nbb);
    }

    public byte[] getData() {
        return this.bytes;
    }

    public byte getUnusedBits() {
        return (byte)this.nbUnusedBits;
    }

    public void setBit(int pos) {
        if (pos < 0 || pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err("ERR_00030", new Object[0]));
        }
        int posInt = this.nbBytes - 1 - (pos + this.nbUnusedBits >> 3);
        int bitNumber = (pos + this.nbUnusedBits) % 8;
        int n = posInt;
        this.bytes[n] = (byte)(this.bytes[n] | 1 << bitNumber);
    }

    public void clearBit(int pos) {
        if (pos < 0 || pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err("ERR_00030", new Object[0]));
        }
        int posInt = this.nbBytes - 1 - (pos + this.nbUnusedBits >> 3);
        int bitNumber = (pos + this.nbUnusedBits) % 8;
        int n = posInt;
        this.bytes[n] = (byte)(this.bytes[n] & ~(1 << bitNumber));
    }

    public boolean getBit(int pos) {
        if (pos > this.nbBits) {
            throw new IndexOutOfBoundsException(I18n.err("ERR_00031", pos, this.nbBits));
        }
        int posInt = this.nbBytes - 1 - (pos + this.nbUnusedBits >> 3);
        int bitNumber = (pos + this.nbUnusedBits) % 8;
        int res = this.bytes[posInt] & 1 << bitNumber;
        return res != 0;
    }

    public int size() {
        return this.nbBytes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = this.nbBits; i > 0; --i) {
            if (this.getBit(i)) {
                sb.append('1');
                continue;
            }
            sb.append('0');
        }
        return sb.toString();
    }

    public boolean isStreamed() {
        return this.isStreamed;
    }
}

