/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.unbind;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnBindRequestCodec
extends LdapMessageCodec {
    private static Logger LOGGER = LoggerFactory.getLogger(UnBindRequestCodec.class);

    public MessageTypeEnum getMessageType() {
        return MessageTypeEnum.UNBIND_REQUEST;
    }

    protected int computeLengthProtocolOp() {
        return 2;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)66);
            buffer.put((byte)0);
        }
        catch (BufferOverflowException boe) {
            String msg = I18n.err("ERR_04005", new Object[0]);
            LOGGER.error(msg);
            throw new EncoderException(msg);
        }
    }

    public String getMessageTypeName() {
        return "UNBIND_REQUEST";
    }

    public String toString() {
        return super.toString("    UnBind Request");
    }
}

