/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Filter;
import org.osgi.service.event.EventProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event {
    private final String topic;
    private final EventProperties properties;

    public Event(String topic, Map<String, ?> properties) {
        Event.validateTopicName(topic);
        this.topic = topic;
        this.properties = properties instanceof EventProperties ? (EventProperties)properties : new EventProperties(properties);
    }

    public Event(String topic, Dictionary<String, ?> properties) {
        Event.validateTopicName(topic);
        this.topic = topic;
        this.properties = new EventProperties(properties);
    }

    public final Object getProperty(String name) {
        if ("event.topics".equals(name)) {
            return this.topic;
        }
        return this.properties.get(name);
    }

    public final boolean containsProperty(String name) {
        if ("event.topics".equals(name)) {
            return true;
        }
        return this.properties.containsKey(name);
    }

    public final String[] getPropertyNames() {
        int size = this.properties.size();
        String[] result = new String[size + 1];
        this.properties.keySet().toArray(result);
        result[size] = "event.topics";
        return result;
    }

    public final String getTopic() {
        return this.topic;
    }

    public final boolean matches(Filter filter) {
        return filter.matchCase(new FilterProperties(this.topic, this.properties));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Event)) {
            return false;
        }
        Event event = (Event)object;
        return this.topic.equals(event.topic) && this.properties.equals(event.properties);
    }

    public int hashCode() {
        int h = 527 + this.topic.hashCode();
        h = 31 * h + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [topic=" + this.topic + "] " + this.properties.toString();
    }

    private static void validateTopicName(String topic) {
        char[] chars = topic.toCharArray();
        int length = chars.length;
        if (length == 0) {
            throw new IllegalArgumentException("empty topic");
        }
        int i = 0;
        while (i < length) {
            char ch = chars[i];
            if (ch == '/') {
                if (i == 0 || i == length - 1) {
                    throw new IllegalArgumentException("invalid topic: " + topic);
                }
                if (chars[i - 1] == '/') {
                    throw new IllegalArgumentException("invalid topic: " + topic);
                }
            } else if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '_' || ch == '-')) {
                throw new IllegalArgumentException("invalid topic: " + topic);
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilterProperties
    extends Dictionary<String, Object> {
        private final String topic;
        private final EventProperties properties;

        FilterProperties(String topic, EventProperties properties) {
            this.topic = topic;
            this.properties = properties;
        }

        @Override
        public Enumeration<Object> elements() {
            Collection<Object> values = this.properties.values();
            ArrayList<Object> result = new ArrayList<Object>(values.size() + 1);
            result.add(this.topic);
            result.addAll(values);
            return Collections.enumeration(result);
        }

        @Override
        public Object get(Object key) {
            if ("event.topics".equals(key)) {
                return this.topic;
            }
            return this.properties.get(key);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Enumeration<String> keys() {
            Set<String> keys = this.properties.keySet();
            ArrayList<String> result = new ArrayList<String>(keys.size() + 1);
            result.add("event.topics");
            result.addAll(keys);
            return Collections.enumeration(result);
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.properties.size() + 1;
        }
    }
}

