/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.security.ldap;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.util.SystemVariableUtil;

public class LDAPUserStoreManager {
    private static final Logger log = LoggerFactory.getLogger(LDAPUserStoreManager.class);
    private static final String USERS_OU = SystemVariableUtil.getValue("LDAP_USER_OU", "ou=Users,dc=WSO2,dc=ORG");
    private static final String GROUPS_OU = SystemVariableUtil.getValue("LDAP_GROUPS_OU", "ou=Groups,dc=WSO2,dc=ORG");
    private static final int DEFAULT_PORT = 389;
    private static Map instances = new HashMap();
    private DirContext context;
    private String hostname;
    private int port;

    protected LDAPUserStoreManager(String hostname, int port, String username, String password) throws NamingException {
        this.context = this.getInitialContext(hostname, port, username, password);
        this.hostname = hostname;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LDAPUserStoreManager getInstance(String hostname, int port, String username, String password) throws NamingException {
        String key = hostname + ":" + port + "|" + (username == null ? "" : username) + "|" + (password == null ? "" : password);
        if (instances.containsKey(key)) return (LDAPUserStoreManager)instances.get(key);
        Class<LDAPUserStoreManager> clazz = LDAPUserStoreManager.class;
        synchronized (LDAPUserStoreManager.class) {
            if (instances.containsKey(key)) return (LDAPUserStoreManager)instances.get(key);
            LDAPUserStoreManager instance = new LDAPUserStoreManager(hostname, port, username, password);
            instances.put(key, instance);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    public static LDAPUserStoreManager getInstance(String hostname) throws NamingException {
        return LDAPUserStoreManager.getInstance(hostname, 389, null, null);
    }

    public void addUser(String username, String firstName, String lastName, String password, String email) throws NamingException {
        BasicAttribute sn;
        BasicAttribute givenName;
        String cnValue;
        BasicAttributes container = new BasicAttributes();
        BasicAttribute objClasses = new BasicAttribute("objectClass");
        objClasses.add("top");
        objClasses.add("person");
        objClasses.add("organizationalPerson");
        objClasses.add("inetOrgPerson");
        if (firstName == null || lastName == null) {
            cnValue = username;
            givenName = new BasicAttribute("givenName", username);
            sn = new BasicAttribute("sn", username);
        } else {
            cnValue = firstName + " " + lastName;
            givenName = new BasicAttribute("givenName", firstName);
            sn = new BasicAttribute("sn", lastName);
        }
        BasicAttribute cn = new BasicAttribute("cn", cnValue);
        BasicAttribute uid = new BasicAttribute("uid", username);
        BasicAttribute mail = new BasicAttribute("mail", email);
        BasicAttribute userPassword = new BasicAttribute("userpassword", password);
        container.put(objClasses);
        container.put(cn);
        container.put(sn);
        container.put(givenName);
        container.put(uid);
        container.put(mail);
        container.put(userPassword);
        this.context.createSubcontext(this.getUserDN(username), (Attributes)container);
    }

    public void deleteUser(String username) throws NamingException {
        try {
            this.context.destroySubcontext(this.getUserDN(username));
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    public boolean isValidUser(String username, String password) throws Exception {
        try {
            this.getInitialContext(this.hostname, this.port, this.getUserDN(username), password);
            return true;
        }
        catch (NameNotFoundException e) {
            throw new Exception("Authentication failed " + username);
        }
        catch (NamingException e) {
            log.error("error", e);
            return false;
        }
    }

    public void addGroup(String name, String description) throws NamingException {
        BasicAttributes container = new BasicAttributes();
        BasicAttribute objClasses = new BasicAttribute("objectClass");
        objClasses.add("top");
        objClasses.add("groupOfNames");
        BasicAttribute cn = new BasicAttribute("cn", name);
        BasicAttribute desc = new BasicAttribute("description", description);
        container.put(objClasses);
        container.put(cn);
        container.put(desc);
        try {
            this.context.createSubcontext(this.getGroupDN(name), (Attributes)container);
        }
        catch (NameAlreadyBoundException e) {
            log.info("Group already exist ..");
        }
    }

    public void deleteGroup(String name) throws NamingException {
        try {
            this.context.destroySubcontext(this.getGroupDN(name));
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    public void assignUser(String username, String groupName) throws NamingException {
        try {
            ModificationItem[] mods = new ModificationItem[1];
            BasicAttribute mod = new BasicAttribute("member", this.getUserDN(username));
            mods[0] = new ModificationItem(1, mod);
            this.context.modifyAttributes(this.getGroupDN(groupName), mods);
        }
        catch (AttributeInUseException attributeInUseException) {
            // empty catch block
        }
    }

    public void removeUser(String username, String groupName) throws NamingException {
        try {
            ModificationItem[] mods = new ModificationItem[1];
            BasicAttribute mod = new BasicAttribute("member", this.getUserDN(username));
            mods[0] = new ModificationItem(3, mod);
            this.context.modifyAttributes(this.getGroupDN(groupName), mods);
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            // empty catch block
        }
    }

    public String getAttributeValue(String username, String attributeName) throws NamingException {
        String attributeValue = null;
        String[] searchAttributes = new String[]{attributeName};
        Attributes attributes = this.context.getAttributes(this.getUserDN(username), searchAttributes);
        if (attributes != null) {
            attributeValue = attributes.get(attributeName).get().toString();
        }
        return attributeValue;
    }

    public void addUserAndAssignGroups(String username, String firstName, String lastName, String password, String email, List<String> groups) throws NamingException {
        this.addUser(username, firstName, lastName, password, email);
        if (groups != null) {
            for (String group : groups) {
                this.assignUser(username, group);
            }
        }
    }

    private String getUserDN(String username) {
        return "uid=" + username + "," + USERS_OU;
    }

    private String getGroupDN(String name) {
        return "cn=" + name + "," + GROUPS_OU;
    }

    private DirContext getInitialContext(String hostname, int port, String username, String password) throws NamingException {
        String providerURL = "ldap://" + hostname + ":" + port;
        Properties props = new Properties();
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        props.put("java.naming.provider.url", providerURL);
        if (username != null && !username.equals("")) {
            props.put("java.naming.security.authentication", "simple");
            props.put("java.naming.security.principal", username);
            props.put("java.naming.security.credentials", password == null ? "" : password);
        }
        return new InitialDirContext(props);
    }
}

