/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.message.EmptyLastHttpContent;
import org.wso2.transport.http.netty.message.EntityCollector;

public class BlockingEntityCollector
implements EntityCollector {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingEntityCollector.class);
    private int soTimeOut;
    private AtomicBoolean alreadyRead;
    private AtomicBoolean endOfMsgAdded;
    private AtomicBoolean isConsumed;
    private BlockingQueue<HttpContent> httpContentQueue;

    public BlockingEntityCollector(int soTimeOut) {
        this.soTimeOut = soTimeOut;
        this.alreadyRead = new AtomicBoolean(false);
        this.endOfMsgAdded = new AtomicBoolean(false);
        this.isConsumed = new AtomicBoolean(false);
        this.httpContentQueue = new LinkedBlockingQueue<HttpContent>();
    }

    @Override
    public void addHttpContent(HttpContent httpContent) {
        try {
            this.isConsumed.set(false);
            this.httpContentQueue.add(httpContent);
        }
        catch (Exception e) {
            LOG.error("Cannot put content to queue", e);
        }
    }

    @Override
    public HttpContent getHttpContent() {
        try {
            if (!this.isConsumed.get() || !this.alreadyRead.get()) {
                HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.SECONDS);
                if (httpContent instanceof LastHttpContent) {
                    this.isConsumed.set(true);
                    this.alreadyRead.set(false);
                    this.httpContentQueue.clear();
                }
                return httpContent;
            }
        }
        catch (InterruptedException e) {
            LOG.error("Error while retrieving http content from queue.", e);
        }
        return null;
    }

    @Override
    public void addMessageBody(ByteBuffer msgBody) {
        this.isConsumed.set(false);
        this.httpContentQueue.add(new DefaultHttpContent(Unpooled.copiedBuffer(msgBody)));
    }

    @Override
    public ByteBuf getMessageBody() {
        HttpContent httpContent = this.getHttpContent();
        if (httpContent != null) {
            return httpContent.content();
        }
        return null;
    }

    @Override
    @Deprecated
    public List<ByteBuffer> getFullMessageBody() {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        if (!this.isConsumed.get()) {
            boolean isEndOfMessageProcessed = false;
            while (!isEndOfMessageProcessed) {
                try {
                    HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.SECONDS);
                    if (httpContent instanceof EmptyLastHttpContent) break;
                    if (httpContent instanceof LastHttpContent) {
                        isEndOfMessageProcessed = true;
                        this.isConsumed.set(true);
                        this.httpContentQueue.clear();
                    }
                    ByteBuf buf = httpContent.content();
                    byteBufferList.add(buf.nioBuffer());
                }
                catch (InterruptedException e) {
                    LOG.error("Error while getting full message body", e);
                }
            }
        }
        return byteBufferList;
    }

    @Override
    public void waitAndReleaseAllEntities() {
        if (!this.isConsumed.get() && !this.alreadyRead.get()) {
            boolean isEndOfMessageProcessed = false;
            while (!isEndOfMessageProcessed) {
                try {
                    HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.SECONDS);
                    if (httpContent instanceof EmptyLastHttpContent) break;
                    if (httpContent instanceof LastHttpContent) {
                        isEndOfMessageProcessed = true;
                        this.isConsumed.set(true);
                    }
                    httpContent.release();
                }
                catch (InterruptedException e) {
                    LOG.error("Error while getting full message body", e);
                }
            }
        }
    }

    @Override
    public int getFullMessageLength() {
        ArrayList<HttpContent> contentList = new ArrayList<HttpContent>();
        boolean isEndOfMessageProcessed = false;
        while (!isEndOfMessageProcessed) {
            try {
                HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.SECONDS);
                if (httpContent instanceof LastHttpContent) {
                    isEndOfMessageProcessed = true;
                }
                contentList.add(httpContent);
            }
            catch (InterruptedException e) {
                LOG.error("Error while getting full message length", e);
            }
        }
        int size = 0;
        for (HttpContent httpContent : contentList) {
            size += httpContent.content().readableBytes();
            this.httpContentQueue.add(httpContent);
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.httpContentQueue.isEmpty();
    }

    @Override
    public boolean isEndOfMsgAdded() {
        return this.endOfMsgAdded.get();
    }

    @Override
    public void markMessageEnd() {
        this.httpContentQueue.add(new EmptyLastHttpContent());
    }

    @Override
    public void setEndOfMsgAdded(boolean endOfMsgAdded) {
        this.endOfMsgAdded.compareAndSet(false, endOfMsgAdded);
        this.httpContentQueue.add(new DefaultLastHttpContent());
    }

    @Override
    public HttpContent peek() {
        return (HttpContent)this.httpContentQueue.peek();
    }

    @Override
    @Deprecated
    public synchronized void release() {
    }

    @Override
    public boolean isAlreadyRead() {
        return this.alreadyRead.get();
    }

    @Override
    public void setAlreadyRead(boolean alreadyRead) {
        this.alreadyRead.set(alreadyRead);
    }
}

