/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.util.Comparator;
import jdbm.btree.BTree;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractTupleCursor;
import org.apache.directory.server.xdbm.Tuple;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTupleBTreeCursor<K, V>
extends AbstractTupleCursor<K, V> {
    private final Comparator<V> comparator;
    private final BTree btree;
    private final K key;
    private jdbm.helper.Tuple valueTuple = new jdbm.helper.Tuple();
    private Tuple<K, V> returnedTuple = new Tuple();
    private TupleBrowser browser;
    private boolean valueAvailable;

    public KeyTupleBTreeCursor(BTree btree, K key, Comparator<V> comparator) throws Exception {
        this.key = key;
        this.btree = btree;
        this.comparator = comparator;
        this.browser = btree.browse();
    }

    private void clearValue() {
        this.returnedTuple.setKey(this.key);
        this.returnedTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    @Override
    public void beforeKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public void afterKey(K key) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
    }

    @Override
    public void beforeValue(K key, V value) throws Exception {
        this.checkNotClosed("beforeValue()");
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
        }
        this.browser = this.btree.browse(value);
        this.clearValue();
    }

    @Override
    public void afterValue(K key, V value) throws Exception {
        if (key != null && !key.equals(this.key)) {
            throw new UnsupportedOperationException(I18n.err(I18n.ERR_446, new Object[0]));
        }
        this.browser = this.btree.browse(value);
        while (this.browser.getNext(this.valueTuple)) {
            this.checkNotClosed("afterValue");
            Object next = this.valueTuple.getKey();
            int nextCompared = this.comparator.compare(next, value);
            if (nextCompared <= 0 || nextCompared <= 0) continue;
            if (!this.browser.getPrevious(this.valueTuple)) {
                this.browser = this.btree.browse(this.key);
            }
            this.clearValue();
            return;
        }
        this.clearValue();
    }

    @Override
    public void before(Tuple<K, V> element) throws Exception {
        this.checkNotClosed("before()");
        this.browser = this.btree.browse(element.getValue());
        this.clearValue();
    }

    @Override
    public void after(Tuple<K, V> element) throws Exception {
        this.afterValue(this.key, element.getValue());
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.browser = this.btree.browse();
        this.clearValue();
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.browser = this.btree.browse(null);
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.browser.getPrevious(this.valueTuple)) {
            if (this.returnedTuple.getValue() != null && this.comparator.compare(this.valueTuple.getKey(), this.returnedTuple.getValue()) == 0) {
                this.browser.getPrevious(this.valueTuple);
            }
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.valueTuple.getKey());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.browser.getNext(this.valueTuple)) {
            if (this.returnedTuple.getValue() != null && this.comparator.compare(this.valueTuple.getKey(), this.returnedTuple.getValue()) == 0) {
                this.browser.getNext(this.valueTuple);
            }
            this.returnedTuple.setKey(this.key);
            this.returnedTuple.setValue(this.valueTuple.getKey());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean isElementReused() {
        return true;
    }
}

