/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.cramMD5;

import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslServer;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5CallbackHandler;
import org.apache.directory.shared.ldap.message.internal.InternalBindRequest;

public class CramMd5MechanismHandler
extends AbstractMechanismHandler {
    public SaslServer handleMechanism(LdapSession ldapSession, InternalBindRequest bindRequest) throws Exception {
        SaslServer ss = (SaslServer)ldapSession.getSaslProperty("saslServer");
        if (ss == null) {
            String saslHost = ldapSession.getLdapServer().getSaslHost();
            String userBaseDn = ldapSession.getLdapServer().getSearchBaseDn();
            ldapSession.putSaslProperty("host", saslHost);
            ldapSession.putSaslProperty("userBaseDn", userBaseDn);
            HashMap saslProps = new HashMap();
            CoreSession adminSession = ldapSession.getLdapServer().getDirectoryService().getAdminSession();
            CramMd5CallbackHandler callbackHandler = new CramMd5CallbackHandler(ldapSession, adminSession, bindRequest);
            ss = Sasl.createSaslServer("CRAM-MD5", "ldap", saslHost, saslProps, callbackHandler);
            ldapSession.putSaslProperty("saslServer", ss);
        }
        return ss;
    }

    public void init(LdapSession ldapSession) {
        String saslHost = ldapSession.getLdapServer().getSaslHost();
        ldapSession.putSaslProperty("host", saslHost);
    }

    public void cleanup(LdapSession ldapSession) {
        ldapSession.clearSaslProperties();
    }
}

