/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.ntlm;

import javax.naming.InvalidNameException;
import javax.security.sasl.SaslException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.interceptor.context.BindOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractSaslServer;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmProvider;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.message.internal.InternalBindRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;

public class NtlmSaslServer
extends AbstractSaslServer {
    private NegotiationState state = NegotiationState.INITIALIZED;
    private final NtlmProvider provider;

    public NtlmSaslServer(NtlmProvider provider, InternalBindRequest bindRequest, LdapSession ldapSession) {
        super(ldapSession, null, bindRequest);
        this.provider = provider;
    }

    public String getMechanismName() {
        return "NTLM";
    }

    protected void responseRecieved() {
        switch (this.state) {
            case INITIALIZED: {
                this.state = NegotiationState.TYPE_1_RECEIVED;
                break;
            }
            case TYPE_1_RECEIVED: {
                throw new IllegalStateException(I18n.err(I18n.ERR_660, new Object[0]));
            }
            case TYPE_2_SENT: {
                this.state = NegotiationState.TYPE_3_RECEIVED;
                break;
            }
            case TYPE_3_RECEIVED: {
                throw new IllegalStateException(I18n.err(I18n.ERR_661, new Object[0]));
            }
            case COMPLETED: {
                throw new IllegalStateException(I18n.err(I18n.ERR_662, new Object[0]));
            }
        }
    }

    protected void responseSent() {
        switch (this.state) {
            case INITIALIZED: {
                throw new IllegalStateException(I18n.err(I18n.ERR_663, new Object[0]));
            }
            case TYPE_1_RECEIVED: {
                this.state = NegotiationState.TYPE_2_SENT;
                break;
            }
            case TYPE_2_SENT: {
                throw new IllegalStateException(I18n.err(I18n.ERR_664, new Object[0]));
            }
            case TYPE_3_RECEIVED: {
                this.state = NegotiationState.COMPLETED;
                break;
            }
            case COMPLETED: {
                throw new IllegalStateException(I18n.err(I18n.ERR_662, new Object[0]));
            }
        }
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (response == null) {
            throw new NullPointerException(I18n.err(I18n.ERR_666, new Object[0]));
        }
        if (response.length == 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_667, new Object[0]));
        }
        this.responseRecieved();
        byte[] retval = null;
        switch (this.state) {
            case TYPE_1_RECEIVED: {
                try {
                    retval = this.provider.generateChallenge(this.getLdapSession().getIoSession(), response);
                    break;
                }
                catch (Exception e) {
                    throw new SaslException(I18n.err(I18n.ERR_668, new Object[0]), e);
                }
            }
            case TYPE_3_RECEIVED: {
                boolean result;
                try {
                    result = this.provider.authenticate(this.getLdapSession().getIoSession(), response);
                    DN dn = this.getBindRequest().getName();
                    dn.normalize(this.getLdapSession().getLdapServer().getDirectoryService().getSchemaManager().getNormalizerMapping());
                    LdapPrincipal ldapPrincipal = new LdapPrincipal(dn, AuthenticationLevel.STRONG);
                    this.getLdapSession().putSaslProperty("saslAuthentUser", ldapPrincipal);
                    this.getLdapSession().putSaslProperty("java.naming.security.principal", this.getBindRequest().getName().toString());
                }
                catch (Exception e) {
                    throw new SaslException(I18n.err(I18n.ERR_669, new Object[0]), e);
                }
                if (result) break;
                throw new SaslException(I18n.err(I18n.ERR_670, new Object[0]));
            }
        }
        this.responseSent();
        return retval;
    }

    private CoreSession authenticate(String user, String password) throws InvalidNameException, Exception {
        BindOperationContext bindContext = new BindOperationContext(this.getLdapSession().getCoreSession());
        bindContext.setDn(new DN(user));
        bindContext.setCredentials(StringTools.getBytesUtf8(password));
        this.getAdminSession().getDirectoryService().getOperationManager().bind(bindContext);
        return bindContext.getSession();
    }

    public boolean isComplete() {
        return this.state == NegotiationState.COMPLETED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NegotiationState {
        INITIALIZED,
        TYPE_1_RECEIVED,
        TYPE_2_SENT,
        TYPE_3_RECEIVED,
        COMPLETED;

    }
}

