/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexNotFoundException;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.SchemaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Store<E, ID> {
    public void setWorkingDirectory(File var1);

    public File getWorkingDirectory();

    public void setUserIndices(Set<Index<?, E, ID>> var1);

    public Set<Index<?, E, ID>> getUserIndices();

    public void setSuffixDn(String var1);

    public String getSuffixDn();

    public void setSyncOnWrite(boolean var1);

    public boolean isSyncOnWrite();

    public void setCacheSize(int var1);

    public int getCacheSize();

    public void setName(String var1);

    public String getName();

    public void init(SchemaManager var1) throws Exception;

    public void destroy() throws Exception;

    public boolean isInitialized();

    public void sync() throws Exception;

    public void addIndex(Index<?, E, ID> var1) throws Exception;

    public Index<String, E, ID> getPresenceIndex();

    public void setPresenceIndex(Index<String, E, ID> var1) throws Exception;

    public Index<ID, E, ID> getOneLevelIndex();

    public void setOneLevelIndex(Index<ID, E, ID> var1) throws Exception;

    public Index<ID, E, ID> getSubLevelIndex();

    public void setSubLevelIndex(Index<ID, E, ID> var1) throws Exception;

    public Index<String, E, ID> getAliasIndex();

    public void setAliasIndex(Index<String, E, ID> var1) throws Exception;

    public Index<ID, E, ID> getOneAliasIndex();

    public void setOneAliasIndex(Index<ID, E, ID> var1) throws Exception;

    public Index<ID, E, ID> getSubAliasIndex();

    public void setSubAliasIndex(Index<ID, E, ID> var1) throws Exception;

    public Index<String, E, ID> getUpdnIndex();

    public void setUpdnIndex(Index<String, E, ID> var1) throws Exception;

    public Index<String, E, ID> getNdnIndex();

    public void setNdnIndex(Index<String, E, ID> var1) throws Exception;

    public Index<String, E, ID> getObjectClassIndex();

    public void setObjectClassIndex(Index<String, E, ID> var1) throws Exception;

    public Index<String, E, ID> getEntryUuidIndex();

    public void setEntryUuidIndex(Index<String, E, ID> var1) throws Exception;

    public Index<String, E, ID> getEntryCsnIndex();

    public void setEntryCsnIndex(Index<String, E, ID> var1) throws Exception;

    public Iterator<String> userIndices();

    public Iterator<String> systemIndices();

    public boolean hasIndexOn(String var1) throws Exception;

    public boolean hasUserIndexOn(String var1) throws Exception;

    public boolean hasSystemIndexOn(String var1) throws Exception;

    public Index<?, E, ID> getIndex(String var1) throws IndexNotFoundException;

    public Index<?, E, ID> getUserIndex(String var1) throws IndexNotFoundException;

    public Index<?, E, ID> getSystemIndex(String var1) throws IndexNotFoundException;

    public ID getEntryId(String var1) throws Exception;

    public String getEntryDn(ID var1) throws Exception;

    public ID getParentId(String var1) throws Exception;

    public ID getParentId(ID var1) throws Exception;

    public String getEntryUpdn(ID var1) throws Exception;

    public String getEntryUpdn(String var1) throws Exception;

    public int count() throws Exception;

    public void add(ServerEntry var1) throws Exception;

    public ServerEntry lookup(ID var1) throws Exception;

    public void delete(ID var1) throws Exception;

    public IndexCursor<ID, E, ID> list(ID var1) throws Exception;

    public int getChildCount(ID var1) throws Exception;

    public DN getSuffix();

    public DN getUpSuffix();

    public void setProperty(String var1, String var2) throws Exception;

    public String getProperty(String var1) throws Exception;

    public void modify(DN var1, ModificationOperation var2, ServerEntry var3) throws Exception;

    public void modify(DN var1, List<Modification> var2) throws Exception;

    public void rename(DN var1, RDN var2, boolean var3) throws Exception;

    public void move(DN var1, DN var2, RDN var3, boolean var4) throws Exception;

    public void move(DN var1, DN var2) throws Exception;

    public ID getDefaultId() throws Exception;
}

