/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.codec.stateful;

import org.apache.directory.shared.asn1.codec.stateful.EncoderCallback;
import org.apache.directory.shared.asn1.codec.stateful.EncoderMonitor;
import org.apache.directory.shared.asn1.codec.stateful.StatefulEncoder;

public abstract class AbstractStatefulEncoder
implements StatefulEncoder {
    private EncoderCallback cb = null;
    private EncoderMonitor monitor = null;

    public AbstractStatefulEncoder() {
    }

    public AbstractStatefulEncoder(EncoderCallback cb) {
        this.setCallback(cb);
    }

    public AbstractStatefulEncoder(EncoderMonitor monitor) {
        this.monitor = monitor;
    }

    public AbstractStatefulEncoder(EncoderCallback cb, EncoderMonitor monitor) {
        this.monitor = monitor;
        this.setCallback(cb);
    }

    public void setCallback(EncoderCallback cb) {
        EncoderCallback old = this.cb;
        this.cb = cb;
        if (this.monitor != null) {
            this.monitor.callbackSet(this, old, cb);
        }
    }

    public void setEncoderMonitor(EncoderMonitor monitor) {
        this.monitor = monitor;
    }

    protected void encodeOccurred(Object encoded) {
        if (this.cb != null) {
            this.cb.encodeOccurred(this, encoded);
        }
    }

    protected EncoderMonitor getEncoderMonitor() {
        return this.monitor;
    }
}

