/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.reponse;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.dsmlv2.DsmlDecorator;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.dom4j.Element;

public class ErrorResponse
extends LdapResponseCodec
implements DsmlDecorator {
    private ErrorResponseType type;
    private String message;
    private int requestID;

    public ErrorResponse() {
    }

    public ErrorResponse(int requestID, ErrorResponseType type, String message) {
        this.requestID = requestID;
        this.type = type;
        this.message = message;
    }

    public Element toDsml(Element root) {
        Element element = root.addElement("errorResponse");
        if (this.requestID != 0) {
            element.addAttribute("requestID", "" + this.requestID);
        }
        element.addAttribute("type", this.getTypeDescr(this.type));
        if (this.message != null && !"".equals(this.message)) {
            Element messageElement = element.addElement("message");
            messageElement.addText(this.message);
        }
        return element;
    }

    public String getTypeDescr(ErrorResponseType type) {
        if (type.equals((Object)ErrorResponseType.NOT_ATTEMPTED)) {
            return "notAttempted";
        }
        if (type.equals((Object)ErrorResponseType.COULD_NOT_CONNECT)) {
            return "couldNotConnect";
        }
        if (type.equals((Object)ErrorResponseType.CONNECTION_CLOSED)) {
            return "connectionClosed";
        }
        if (type.equals((Object)ErrorResponseType.MALFORMED_REQUEST)) {
            return "malformedRequest";
        }
        if (type.equals((Object)ErrorResponseType.GATEWAY_INTERNAL_ERROR)) {
            return "gatewayInternalError";
        }
        if (type.equals((Object)ErrorResponseType.AUTHENTICATION_FAILED)) {
            return "authenticationFailed";
        }
        if (type.equals((Object)ErrorResponseType.UNRESOLVABLE_URI)) {
            return "unresolvableURI";
        }
        if (type.equals((Object)ErrorResponseType.OTHER)) {
            return "other";
        }
        return "unknown";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public void setRequestID(int requestID) {
        this.requestID = requestID;
    }

    public ErrorResponseType getType() {
        return this.type;
    }

    public void setType(ErrorResponseType type) {
        this.type = type;
    }

    protected int computeLengthProtocolOp() {
        return 0;
    }

    protected void encodeProtocolOp(ByteBuffer buffer) throws EncoderException {
    }

    public MessageTypeEnum getMessageType() {
        return null;
    }

    public String getMessageTypeName() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorResponseType {
        NOT_ATTEMPTED,
        COULD_NOT_CONNECT,
        CONNECTION_CLOSED,
        MALFORMED_REQUEST,
        GATEWAY_INTERNAL_ERROR,
        AUTHENTICATION_FAILED,
        UNRESOLVABLE_URI,
        OTHER;

    }
}

