/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search.controls.entryChange;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.codec.search.controls.ChangeType;
import org.apache.directory.shared.ldap.codec.search.controls.entryChange.EntryChangeControlDecoder;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.StringTools;

public class EntryChangeControl
extends AbstractControl {
    public static final String CONTROL_OID = "2.16.840.1.113730.3.4.7";
    public static final int UNDEFINED_CHANGE_NUMBER = -1;
    private ChangeType changeType = ChangeType.ADD;
    private long changeNumber = -1L;
    private DN previousDn = null;
    private byte[] previousDnBytes = null;
    private int eccSeqLength;

    public EntryChangeControl() {
        super(CONTROL_OID);
        this.decoder = new EntryChangeControlDecoder();
    }

    public int computeLength() {
        int changeTypesLength = 3;
        int previousDnLength = 0;
        int changeNumberLength = 0;
        if (this.previousDn != null) {
            this.previousDnBytes = StringTools.getBytesUtf8(this.previousDn.getName());
            previousDnLength = 1 + TLV.getNbBytes(this.previousDnBytes.length) + this.previousDnBytes.length;
        }
        if (this.changeNumber != -1L) {
            changeNumberLength = 2 + Value.getNbBytes(this.changeNumber);
        }
        this.eccSeqLength = changeTypesLength + previousDnLength + changeNumberLength;
        this.valueLength = 1 + TLV.getNbBytes(this.eccSeqLength) + this.eccSeqLength;
        return super.computeLength(this.valueLength);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err("ERR_04023", new Object[0]));
        }
        super.encode(buffer);
        buffer.put((byte)4);
        buffer.put(TLV.getBytes(this.valueLength));
        buffer.put((byte)48);
        buffer.put(TLV.getBytes(this.eccSeqLength));
        buffer.put((byte)10);
        buffer.put((byte)1);
        buffer.put(Value.getBytes(this.changeType.getValue()));
        if (this.previousDn != null) {
            Value.encode(buffer, this.previousDnBytes);
        }
        if (this.changeNumber != -1L) {
            Value.encode(buffer, this.changeNumber);
        }
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put((byte)48);
                buffer.put(TLV.getBytes(this.eccSeqLength));
                buffer.put((byte)10);
                buffer.put((byte)1);
                buffer.put(Value.getBytes(this.changeType.getValue()));
                if (this.previousDn != null) {
                    Value.encode(buffer, this.previousDnBytes);
                }
                if (this.changeNumber != -1L) {
                    Value.encode(buffer, this.changeNumber);
                }
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public DN getPreviousDn() {
        return this.previousDn;
    }

    public void setPreviousDn(DN previousDn) {
        this.previousDn = previousDn;
    }

    public long getChangeNumber() {
        return this.changeNumber;
    }

    public void setChangeNumber(long changeNumber) {
        this.changeNumber = changeNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Entry Change Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        changeType   : '").append(this.changeType).append("'\n");
        sb.append("        previousDN   : '").append(this.previousDn).append("'\n");
        if (this.changeNumber == -1L) {
            sb.append("        changeNumber : '").append("UNDEFINED").append("'\n");
        } else {
            sb.append("        changeNumber : '").append(this.changeNumber).append("'\n");
        }
        return sb.toString();
    }
}

