/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.Map;
import org.apache.directory.shared.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AliasDerefMode {
    NEVER_DEREF_ALIASES(0, "never"),
    DEREF_IN_SEARCHING(1, "searching"),
    DEREF_FINDING_BASE_OBJ(2, "finding"),
    DEREF_ALWAYS(3, "always");

    private int value;
    private String jndiValue;

    private AliasDerefMode(int value, String jndiValue) {
        this.value = value;
        this.jndiValue = jndiValue;
    }

    public int getValue() {
        return this.value;
    }

    public static AliasDerefMode getEnum(Map<String, Object> env) {
        String property = (String)env.get("java.naming.ldap.derefAliases");
        if (null == property) {
            return DEREF_ALWAYS;
        }
        if (property.trim().equalsIgnoreCase("always")) {
            return DEREF_ALWAYS;
        }
        if (property.trim().equalsIgnoreCase("never")) {
            return NEVER_DEREF_ALIASES;
        }
        if (property.trim().equalsIgnoreCase("finding")) {
            return DEREF_FINDING_BASE_OBJ;
        }
        if (property.trim().equalsIgnoreCase("searching")) {
            return DEREF_IN_SEARCHING;
        }
        throw new IllegalArgumentException(I18n.err("ERR_04186", property, "java.naming.ldap.derefAliases"));
    }

    public boolean isDerefAlways() {
        return this == DEREF_ALWAYS;
    }

    public boolean isNeverDeref() {
        return this == NEVER_DEREF_ALIASES;
    }

    public boolean isDerefInSearching() {
        switch (this) {
            case DEREF_ALWAYS: {
                return true;
            }
            case DEREF_FINDING_BASE_OBJ: {
                return false;
            }
            case DEREF_IN_SEARCHING: {
                return true;
            }
            case NEVER_DEREF_ALIASES: {
                return false;
            }
        }
        throw new IllegalArgumentException(I18n.err("ERR_04187", new Object[0]));
    }

    public boolean isDerefFindingBase() {
        switch (this) {
            case DEREF_ALWAYS: {
                return true;
            }
            case DEREF_FINDING_BASE_OBJ: {
                return true;
            }
            case DEREF_IN_SEARCHING: {
                return false;
            }
            case NEVER_DEREF_ALIASES: {
                return false;
            }
        }
        throw new IllegalArgumentException("Class has bug: check for valid enumeration values");
    }

    public String getJndiValue() {
        return this.jndiValue;
    }
}

