/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatingSystemMetricSet
implements MetricSet {
    private static final Logger logger = LoggerFactory.getLogger(OperatingSystemMetricSet.class);
    private final OperatingSystemMXBean mxBean;

    public OperatingSystemMetricSet() {
        this(ManagementFactory.getOperatingSystemMXBean());
    }

    public OperatingSystemMetricSet(OperatingSystemMXBean mxBean) {
        this.mxBean = mxBean;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        Gauge<Long> committedVirtualMemorySizeGauge;
        Gauge<Long> totalSwapSpaceSizeGauge;
        Gauge<Long> freeSwapSpaceSizeGauge;
        Gauge<Long> totalPhysicalMemorySizeGauge;
        Gauge<Long> freePhysicalMemorySizeGauge;
        Gauge<Double> systemCpuLoadGauge;
        Gauge<Double> processCpuLoadGauge;
        Gauge<Long> maxFileDescriptorCountGauge;
        HashMap<String, Gauge<Number>> gauges = new HashMap<String, Gauge<Number>>();
        double loadAverage = this.mxBean.getSystemLoadAverage();
        if (Double.compare(loadAverage, 0.0) >= 0) {
            gauges.put("system.load.average", this.mxBean::getSystemLoadAverage);
        } else if (logger.isDebugEnabled()) {
            logger.debug("System Load Average is not available as an Operating System Metric");
        }
        Gauge<Long> openFileDescriptorCountGauge = this.getLongGauge("getOpenFileDescriptorCount");
        if (openFileDescriptorCountGauge != null) {
            gauges.put("file.descriptor.open.count", openFileDescriptorCountGauge);
        }
        if ((maxFileDescriptorCountGauge = this.getLongGauge("getMaxFileDescriptorCount")) != null) {
            gauges.put("file.descriptor.max.count", maxFileDescriptorCountGauge);
        }
        if ((processCpuLoadGauge = this.getDoubleGauge("getProcessCpuLoad")) != null) {
            gauges.put("cpu.load.process", processCpuLoadGauge);
        }
        if ((systemCpuLoadGauge = this.getDoubleGauge("getSystemCpuLoad")) != null) {
            gauges.put("cpu.load.system", systemCpuLoadGauge);
        }
        if ((freePhysicalMemorySizeGauge = this.getLongGauge("getFreePhysicalMemorySize")) != null) {
            gauges.put("physical.memory.free.size", freePhysicalMemorySizeGauge);
        }
        if ((totalPhysicalMemorySizeGauge = this.getLongGauge("getTotalPhysicalMemorySize")) != null) {
            gauges.put("physical.memory.total.size", totalPhysicalMemorySizeGauge);
        }
        if ((freeSwapSpaceSizeGauge = this.getLongGauge("getFreeSwapSpaceSize")) != null) {
            gauges.put("swap.space.free.size", freeSwapSpaceSizeGauge);
        }
        if ((totalSwapSpaceSizeGauge = this.getLongGauge("getTotalSwapSpaceSize")) != null) {
            gauges.put("swap.space.total.size", totalSwapSpaceSizeGauge);
        }
        if ((committedVirtualMemorySizeGauge = this.getLongGauge("getCommittedVirtualMemorySize")) != null) {
            gauges.put("virtual.memory.committed.size", committedVirtualMemorySizeGauge);
        }
        return Collections.unmodifiableMap(gauges);
    }

    private Gauge<Long> getLongGauge(String methodName) {
        Object value = this.getValue(methodName);
        if (value != null && value instanceof Long) {
            return () -> this.invokeLong(methodName);
        }
        return null;
    }

    private Gauge<Double> getDoubleGauge(String methodName) {
        Object value = this.getValue(methodName);
        if (value != null && value instanceof Double) {
            return () -> this.invokeDouble(methodName);
        }
        return null;
    }

    private Object getValue(String methodName) {
        Object value;
        block2: {
            value = null;
            try {
                value = this.invokeMethod(methodName);
            }
            catch (Throwable e) {
                if (!logger.isTraceEnabled()) break block2;
                logger.trace(String.format("Error when invoking %s", methodName), e);
            }
        }
        return value;
    }

    private Object invokeMethod(String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.mxBean.getClass().getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        return method.invoke((Object)this.mxBean, new Object[0]);
    }

    private long invokeLong(String methodName) {
        try {
            return (Long)this.invokeMethod(methodName);
        }
        catch (Throwable e) {
            return 0L;
        }
    }

    private double invokeDouble(String methodName) {
        try {
            return (Double)this.invokeMethod(methodName);
        }
        catch (Throwable e) {
            return -1.0;
        }
    }
}

