/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.security;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;
import org.wso2.msf4j.examples.petstore.util.model.User;

public class JWTGenerator {
    private static String keyStore = "wso2carbon.jks";
    private String alias = "wso2carbon";
    private String keyStorePassword = "wso2carbon";

    protected String generateJWT(User user) throws Exception {
        RSAPrivateKey privateKey = this.getPrivateKey(keyStore, this.keyStorePassword, this.alias);
        RSASSASigner signer = new RSASSASigner(privateKey);
        JWTClaimsSet claimsSet = new JWTClaimsSet();
        claimsSet.setSubject(user.getName());
        claimsSet.setClaim("email", user.getEmail());
        claimsSet.setClaim("roles", user.getRoles());
        claimsSet.setIssuer("wso2.org/products/msf4j");
        claimsSet.setExpirationTime(new Date(new Date().getTime() + 3600000L));
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), claimsSet);
        signedJWT.sign(signer);
        return signedJWT.serialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RSAPrivateKey getPrivateKey(String keyStorePath, String keyStorePassword, String alias) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        try (InputStream inputStream = null;){
            RSAPrivateKey privateKey;
            inputStream = this.getClass().getClassLoader().getResourceAsStream(keyStorePath);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(inputStream, keyStorePassword.toCharArray());
            RSAPrivateKey rSAPrivateKey = privateKey = (RSAPrivateKey)keystore.getKey(alias, keyStorePassword.toCharArray());
            return rSAPrivateKey;
        }
    }
}

