/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReader;
import org.apache.axiom.om.impl.SwitchingWrapper;
import org.apache.axiom.util.stax.xop.ContentIDGenerator;
import org.apache.axiom.util.stax.xop.OptimizationPolicy;
import org.apache.axiom.util.stax.xop.XOPEncodingStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OMStAXWrapper
extends StreamReaderDelegate
implements OMXMLStreamReader {
    private static final Log log = LogFactory.getLog(OMStAXWrapper.class);
    private final SwitchingWrapper switchingWrapper;
    private XOPEncodingStreamReader xopEncoder;

    public OMStAXWrapper(OMXMLParserWrapper builder, OMContainer startNode) {
        this(builder, startNode, false);
    }

    public OMStAXWrapper(OMXMLParserWrapper builder, OMContainer startNode, boolean cache) {
        this.switchingWrapper = new SwitchingWrapper(builder, startNode, cache);
        this.setParent(this.switchingWrapper);
    }

    public boolean isInlineMTOM() {
        return this.xopEncoder == null;
    }

    public void setInlineMTOM(boolean value) {
        if (value) {
            if (this.xopEncoder != null) {
                this.xopEncoder = null;
                this.setParent(this.switchingWrapper);
            }
        } else if (this.xopEncoder == null) {
            this.xopEncoder = new XOPEncodingStreamReader(this.switchingWrapper, ContentIDGenerator.DEFAULT, OptimizationPolicy.ALL);
            this.setParent(this.xopEncoder);
        }
    }

    public DataHandler getDataHandler(String contentID) {
        DataHandler dh;
        OMXMLParserWrapper builder;
        if (contentID.startsWith("cid:")) {
            log.warn("Invalid usage of OMStAXWrapper#getDataHandler(String): the argument must be a content ID, not an href; see OMAttachmentAccessor.");
            contentID = contentID.substring(4);
        }
        if ((builder = this.switchingWrapper.getBuilder()) != null && builder instanceof OMAttachmentAccessor && (dh = ((OMAttachmentAccessor)((Object)builder)).getDataHandler(contentID)) != null) {
            return dh;
        }
        if (this.xopEncoder == null) {
            throw new IllegalStateException("The wrapper is in inlineMTOM=true mode");
        }
        if (this.xopEncoder.getContentIDs().contains(contentID)) {
            try {
                return this.xopEncoder.getDataHandler(contentID);
            }
            catch (IOException ex) {
                throw new OMException(ex);
            }
        }
        return null;
    }

    public OMXMLParserWrapper getBuilder() {
        return this.switchingWrapper.getBuilder();
    }

    public boolean isAllowSwitching() {
        return this.switchingWrapper.isAllowSwitching();
    }

    public boolean isClosed() {
        return this.switchingWrapper.isClosed();
    }

    public void releaseParserOnClose(boolean value) {
        this.switchingWrapper.releaseParserOnClose(value);
    }

    public void setAllowSwitching(boolean b) {
        this.switchingWrapper.setAllowSwitching(b);
    }

    public void setParser(XMLStreamReader parser) {
        this.switchingWrapper.setParser(parser);
    }

    public void setNamespaceURIInterning(boolean b) {
        this.switchingWrapper.setNamespaceURIInterning(b);
    }

    public OMDataSource getDataSource() {
        return this.switchingWrapper.getDataSource();
    }

    public void enableDataSourceEvents(boolean value) {
        this.switchingWrapper.enableDataSourceEvents(value);
    }
}

