/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import org.apache.directory.server.core.event.EventType;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.FilterParser;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.internal.InternalSearchRequest;
import org.apache.directory.shared.ldap.name.DN;

public class NotificationCriteria {
    public static final SearchScope DEFAULT_SCOPE = SearchScope.ONELEVEL;
    public static final AliasDerefMode DEFAULT_ALIAS_DEREF_MODE = AliasDerefMode.DEREF_ALWAYS;
    public static final DN DEFAULT_BASE = new DN();
    public static final ExprNode DEFAULT_FILTER = new PresenceNode("2.5.4.0");
    private SearchScope scope = DEFAULT_SCOPE;
    private AliasDerefMode aliasDerefMode = DEFAULT_ALIAS_DEREF_MODE;
    private DN base = DEFAULT_BASE;
    private ExprNode filter = DEFAULT_FILTER;
    private int eventMask = EventType.ALL_EVENT_TYPES_MASK;

    public NotificationCriteria() {
    }

    public NotificationCriteria(InternalSearchRequest req) {
        this.scope = req.getScope();
        this.aliasDerefMode = req.getDerefAliases();
        this.base = req.getBase();
        this.filter = req.getFilter();
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setAliasDerefMode(AliasDerefMode aliasDerefMode) {
        this.aliasDerefMode = aliasDerefMode;
    }

    public AliasDerefMode getAliasDerefMode() {
        return this.aliasDerefMode;
    }

    public void setBase(DN base) {
        this.base = base;
    }

    public void setBase(String base) throws Exception {
        this.base = new DN(base);
    }

    public DN getBase() {
        return this.base;
    }

    public void setFilter(ExprNode filter) {
        this.filter = filter;
    }

    public void setFilter(String filter) throws Exception {
        this.filter = FilterParser.parse(filter);
    }

    public ExprNode getFilter() {
        return this.filter;
    }

    public void setEventMask(int eventMask) {
        this.eventMask = eventMask;
    }

    public void setEventMask(EventType ... eventTypes) {
        this.eventMask = EventType.getMask(eventTypes);
    }

    public int getEventMask() {
        return this.eventMask;
    }
}

