/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAdapter
implements Map<Object, Object> {
    private Dictionary<Object, Object> dictionary;

    public MapAdapter(Dictionary<Object, Object> dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public void clear() {
        this.dictionary = new Hashtable<Object, Object>();
    }

    @Override
    public boolean containsKey(Object key) {
        return Collections.list(this.dictionary.keys()).contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return Collections.list(this.dictionary.elements()).contains(value);
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Enumeration<Object> e = this.dictionary.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = this.dictionary.get(key);
            map.put(key, value);
        }
        return map.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.dictionary.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.dictionary.isEmpty();
    }

    @Override
    public Set<Object> keySet() {
        return new HashSet<Object>(Collections.list(this.dictionary.keys()));
    }

    @Override
    public Object put(Object arg0, Object arg1) {
        return this.dictionary.put(arg0, arg1);
    }

    @Override
    public void putAll(Map arg0) {
        for (Map.Entry entry : arg0.entrySet()) {
            this.dictionary.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.dictionary.remove(key);
    }

    @Override
    public int size() {
        return this.dictionary.size();
    }

    @Override
    public Collection<Object> values() {
        return Collections.list(this.dictionary.elements());
    }
}

