/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value.types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HostAddrType {
    NULL(0),
    ADDRTYPE_INET(2),
    ADDRTYPE_IMPLINK(3),
    ADDRTYPE_CHAOS(5),
    ADDRTYPE_XNS(6),
    ADDRTYPE_OSI(7),
    ADDRTYPE_DECNET(12),
    ADDRTYPE_APPLETALK(16),
    ADDRTYPE_NETBIOS(20),
    ADDRTYPE_INET6(24);

    private final int ordinal;

    private HostAddrType(int ordinal) {
        this.ordinal = ordinal;
    }

    public static HostAddrType getTypeByOrdinal(int type) {
        switch (type) {
            case 0: {
                return NULL;
            }
            case 2: {
                return ADDRTYPE_INET;
            }
            case 3: {
                return ADDRTYPE_IMPLINK;
            }
            case 5: {
                return ADDRTYPE_CHAOS;
            }
            case 6: {
                return ADDRTYPE_XNS;
            }
            case 7: {
                return ADDRTYPE_OSI;
            }
            case 12: {
                return ADDRTYPE_DECNET;
            }
            case 16: {
                return ADDRTYPE_APPLETALK;
            }
            case 20: {
                return ADDRTYPE_NETBIOS;
            }
            case 24: {
                return ADDRTYPE_INET6;
            }
        }
        return NULL;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String toString() {
        switch (this.ordinal) {
            case 2: {
                return "Internet(" + this.ordinal + ")";
            }
            case 3: {
                return "Arpanet(" + this.ordinal + ")";
            }
            case 5: {
                return "CHAOS(" + this.ordinal + ")";
            }
            case 6: {
                return "XEROX Network Services(" + this.ordinal + ")";
            }
            case 7: {
                return "OSI(" + this.ordinal + ")";
            }
            case 12: {
                return "DECnet(" + this.ordinal + ")";
            }
            case 20: {
                return "NetBios(" + this.ordinal + ")";
            }
            case 24: {
                return "Internet Protocol V6(" + this.ordinal + ")";
            }
        }
        return "null(" + this.ordinal + ")";
    }
}

