/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.gui;

import java.net.InetSocketAddress;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.ldap.LdapSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionsModel
implements TableModel {
    final String[] columns = new String[]{"client address", "client port", "server address", "server port"};
    final Class<?>[] columnClasses = new Class[]{String.class, Integer.class, String.class, Integer.class};
    final LdapSession[] sessions;

    SessionsModel(LdapSession[] sessions) {
        this.sessions = sessions;
    }

    LdapSession getLdapSession(int row) {
        return this.sessions[row];
    }

    @Override
    public int getRowCount() {
        return this.sessions.length;
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClasses[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LdapSession session = this.sessions[rowIndex];
        switch (columnIndex) {
            case 0: {
                return ((InetSocketAddress)session.getIoSession().getRemoteAddress()).getHostName();
            }
            case 1: {
                return new Integer(((InetSocketAddress)session.getIoSession().getRemoteAddress()).getPort());
            }
            case 2: {
                return ((InetSocketAddress)session.getIoSession().getLocalAddress()).getHostName();
            }
            case 3: {
                return new Integer(((InetSocketAddress)session.getIoSession().getLocalAddress()).getPort());
            }
        }
        throw new IndexOutOfBoundsException(I18n.err(I18n.ERR_658, this.columns.length - 1));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

