/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.AssertionNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOptimizer<E, ID>
implements Optimizer {
    private final Store<E, ID> db;
    private ID contextEntryId;

    public DefaultOptimizer(Store<E, ID> db) throws Exception {
        this.db = db;
    }

    private ID getContextEntryId() throws Exception {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(this.db.getSuffix().getNormName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return this.db.getDefaultId();
        }
        return this.contextEntryId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Long annotate(ExprNode node) throws Exception {
        Long count = Long.MAX_VALUE;
        if (node instanceof ScopeNode) {
            count = this.getScopeScan((ScopeNode)node);
        } else if (!(node instanceof AssertionNode)) {
            if (node.isLeaf()) {
                LeafNode leaf = (LeafNode)node;
                if (node instanceof PresenceNode) {
                    count = this.getPresenceScan((PresenceNode)leaf);
                } else if (node instanceof EqualityNode) {
                    count = this.getEqualityScan((EqualityNode)leaf);
                } else if (node instanceof GreaterEqNode) {
                    count = this.getGreaterLessScan((GreaterEqNode)leaf, true);
                } else if (node instanceof LessEqNode) {
                    count = this.getGreaterLessScan((SimpleNode)leaf, false);
                } else if (node instanceof SubstringNode) {
                    count = this.getFullScan(leaf);
                } else if (node instanceof ExtensibleNode) {
                    count = this.getFullScan(leaf);
                } else {
                    if (!(node instanceof ApproximateNode)) throw new IllegalArgumentException(I18n.err(I18n.ERR_711, new Object[0]));
                    count = this.getEqualityScan((ApproximateNode)leaf);
                }
            } else if (node instanceof AndNode) {
                count = this.getConjunctionScan((AndNode)node);
            } else if (node instanceof OrNode) {
                count = this.getDisjunctionScan((OrNode)node);
            } else {
                if (!(node instanceof NotNode)) throw new IllegalArgumentException(I18n.err(I18n.ERR_712, new Object[0]));
                this.annotate(((NotNode)node).getFirstChild());
                count = Long.MAX_VALUE;
            }
        }
        if (count < 0L) {
            count = Long.MAX_VALUE;
        }
        node.set("count", count);
        return count;
    }

    private long getConjunctionScan(BranchNode node) throws Exception {
        long count = Long.MAX_VALUE;
        List<ExprNode> children = node.getChildren();
        for (ExprNode child : children) {
            this.annotate(child);
            count = Math.min((Long)child.get("count"), count);
        }
        return count;
    }

    private long getDisjunctionScan(BranchNode node) throws Exception {
        List<ExprNode> children = node.getChildren();
        long total = 0L;
        for (ExprNode child : children) {
            this.annotate(child);
            total += ((Long)child.get("count")).longValue();
        }
        return total;
    }

    private <V> long getEqualityScan(SimpleNode<V> node) throws Exception {
        if (this.db.hasIndexOn(node.getAttribute())) {
            Index<?, E, ID> idx = this.db.getIndex(node.getAttribute());
            return idx.count(node.getValue().get());
        }
        return Long.MAX_VALUE;
    }

    private <V> long getGreaterLessScan(SimpleNode<V> node, boolean isGreaterThan) throws Exception {
        if (this.db.hasIndexOn(node.getAttribute())) {
            Index<?, E, ID> idx = this.db.getIndex(node.getAttribute());
            if (isGreaterThan) {
                return idx.greaterThanCount(node.getValue().get());
            }
            return idx.lessThanCount(node.getValue().get());
        }
        return Long.MAX_VALUE;
    }

    private long getFullScan(LeafNode node) throws Exception {
        if (this.db.hasIndexOn(node.getAttribute())) {
            Index<?, E, ID> idx = this.db.getIndex(node.getAttribute());
            return idx.count();
        }
        return Long.MAX_VALUE;
    }

    private long getPresenceScan(PresenceNode node) throws Exception {
        if (this.db.hasUserIndexOn(node.getAttribute())) {
            Index<String, E, ID> idx = this.db.getPresenceIndex();
            return idx.count(node.getAttribute());
        }
        if (this.db.hasSystemIndexOn(node.getAttribute())) {
            Index<?, E, ID> idx = this.db.getSystemIndex(node.getAttribute());
            return idx.count();
        }
        return Long.MAX_VALUE;
    }

    private long getScopeScan(ScopeNode node) throws Exception {
        ID id = this.db.getEntryId(node.getBaseDn());
        switch (node.getScope()) {
            case OBJECT: {
                return 1L;
            }
            case ONELEVEL: {
                return this.db.getChildCount(id);
            }
            case SUBTREE: {
                if (id == this.getContextEntryId()) {
                    return this.db.count();
                }
                return this.db.getSubLevelIndex().count(id);
            }
        }
        throw new IllegalArgumentException(I18n.err(I18n.ERR_713, new Object[0]));
    }
}

