/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.ldif.LdapLdifException;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifAttributesReader
extends LdifReader {
    private static final Logger LOG = LoggerFactory.getLogger(LdifAttributesReader.class);

    public LdifAttributesReader() {
        this.lines = new ArrayList();
        this.position = new LdifReader.Position();
        this.version = 1;
    }

    private void parseAttribute(Attributes attributes, String line, String lowerLine) throws LdapLdifException {
        int colonIndex = line.indexOf(58);
        String attributeType = lowerLine.substring(0, colonIndex);
        if (attributeType.equals("dn")) {
            LOG.error(I18n.err("ERR_12002", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12003", new Object[0]));
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        Attribute attribute = attributes.get(attributeType);
        if (attribute == null) {
            attributes.put(attributeType, attributeValue);
        } else {
            attribute.add(attributeValue);
        }
    }

    private void parseEntryAttribute(Entry entry, String line, String lowerLine) throws LdapLdifException {
        int colonIndex = line.indexOf(58);
        String attributeType = lowerLine.substring(0, colonIndex);
        if (attributeType.equals("dn")) {
            LOG.error(I18n.err("ERR_12002", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12003", new Object[0]));
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        EntryAttribute attribute = entry.get(attributeType);
        if (attribute == null) {
            if (attributeValue instanceof String) {
                entry.put(attributeType, (String)attributeValue);
            } else {
                entry.put(attributeType, new byte[][]{(byte[])attributeValue});
            }
        } else if (attributeValue instanceof String) {
            attribute.add((String)attributeValue);
        } else {
            attribute.add(new byte[][]{(byte[])attributeValue});
        }
    }

    private Entry parseEntry() throws LdapLdifException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        DefaultClientEntry entry = new DefaultClientEntry();
        for (String line : this.lines) {
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("control:")) {
                LOG.error(I18n.err("ERR_12004", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12005", new Object[0]));
            }
            if (lowerLine.startsWith("changetype:")) {
                LOG.error(I18n.err("ERR_12004", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12005", new Object[0]));
            }
            if (line.indexOf(58) > 0) {
                this.parseEntryAttribute(entry, line, lowerLine);
                continue;
            }
            LOG.error(I18n.err("ERR_12006", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12007", new Object[0]));
        }
        LOG.debug("Read an attributes : {}", (Object)entry);
        return entry;
    }

    private Attributes parseAttributes() throws LdapLdifException {
        if (this.lines == null || this.lines.size() == 0) {
            LOG.debug("The entry is empty : end of ldif file");
            return null;
        }
        BasicAttributes attributes = new BasicAttributes(true);
        for (String line : this.lines) {
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("control:")) {
                LOG.error(I18n.err("ERR_12004", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12005", new Object[0]));
            }
            if (lowerLine.startsWith("changetype:")) {
                LOG.error(I18n.err("ERR_12004", new Object[0]));
                throw new LdapLdifException(I18n.err("ERR_12005", new Object[0]));
            }
            if (line.indexOf(58) > 0) {
                this.parseAttribute(attributes, line, lowerLine);
                continue;
            }
            LOG.error(I18n.err("ERR_12006", new Object[0]));
            throw new LdapLdifException(I18n.err("ERR_12007", new Object[0]));
        }
        LOG.debug("Read an attributes : {}", (Object)attributes);
        return attributes;
    }

    public Attributes parseAttributes(String ldif) throws LdapLdifException {
        this.lines = new ArrayList();
        this.position = new LdifReader.Position();
        LOG.debug("Starts parsing ldif buffer");
        if (StringTools.isEmpty(ldif)) {
            return new BasicAttributes(true);
        }
        StringReader strIn = new StringReader(ldif);
        this.reader = new BufferedReader(strIn);
        try {
            this.readLines();
            Attributes attributes = this.parseAttributes();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed {} entries.", (Object)(attributes == null ? 0 : 1));
            }
            Attributes attributes2 = attributes;
            return attributes2;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err("ERR_12008", ne.getLocalizedMessage()));
            throw new LdapLdifException(I18n.err("ERR_12009", new Object[0]));
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException ioe) {}
        }
    }

    public Entry parseEntry(String ldif) throws LdapLdifException {
        this.lines = new ArrayList();
        this.position = new LdifReader.Position();
        LOG.debug("Starts parsing ldif buffer");
        if (StringTools.isEmpty(ldif)) {
            return new DefaultClientEntry();
        }
        StringReader strIn = new StringReader(ldif);
        this.reader = new BufferedReader(strIn);
        try {
            this.readLines();
            Entry entry = this.parseEntry();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsed {} entries.", (Object)(entry == null ? 0 : 1));
            }
            Entry entry2 = entry;
            return entry2;
        }
        catch (LdapLdifException ne) {
            LOG.error(I18n.err("ERR_12008", ne.getLocalizedMessage()));
            throw new LdapLdifException(I18n.err("ERR_12009", new Object[0]));
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException ioe) {}
        }
    }
}

