/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.endpoint.binary;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.databridge.agent.endpoint.binary.BinaryDataEndpoint;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.binary.BinaryMessageConverterUtil;

public class BinaryEventSender {
    public static void sendBinaryLoginMessage(Socket socket, String userName, String password) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(13 + userName.length() + password.length());
        buf.put((byte)0);
        buf.putInt(8 + userName.length() + password.length());
        buf.putInt(userName.length());
        buf.putInt(password.length());
        buf.put(userName.getBytes("UTF-8"));
        buf.put(password.getBytes("UTF-8"));
        BufferedOutputStream outputStream = new BufferedOutputStream(socket.getOutputStream());
        ((OutputStream)outputStream).write(buf.array());
        ((OutputStream)outputStream).flush();
    }

    public static void sendBinaryLogoutMessage(Socket socket, String sessionId) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(9 + sessionId.length());
        buf.put((byte)1);
        buf.putInt(4 + sessionId.length());
        buf.putInt(sessionId.length());
        buf.put(sessionId.getBytes("UTF-8"));
        BufferedOutputStream outputStream = new BufferedOutputStream(socket.getOutputStream());
        ((OutputStream)outputStream).write(buf.array());
        ((OutputStream)outputStream).flush();
    }

    public static void sendBinaryPublishMessage(Socket socket, List<Event> events, String sessionId) throws IOException {
        int messageSize = 8 + sessionId.length();
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        for (Event event : events) {
            int eventSize = BinaryEventSender.getEventSize(event);
            messageSize += eventSize + 4;
            ByteBuffer eventDataBuffer = ByteBuffer.allocate(4 + eventSize);
            eventDataBuffer.putInt(eventSize);
            eventDataBuffer.putLong(event.getTimeStamp());
            eventDataBuffer.putInt(event.getStreamId().length());
            eventDataBuffer.put(event.getStreamId().getBytes("UTF-8"));
            if (event.getMetaData() != null && event.getMetaData().length != 0) {
                for (Object aMetaData : event.getMetaData()) {
                    BinaryMessageConverterUtil.assignData(aMetaData, eventDataBuffer);
                }
            }
            if (event.getCorrelationData() != null && event.getCorrelationData().length != 0) {
                for (Object aCorrelationData : event.getCorrelationData()) {
                    BinaryMessageConverterUtil.assignData(aCorrelationData, eventDataBuffer);
                }
            }
            if (event.getPayloadData() != null && event.getPayloadData().length != 0) {
                for (Object aPayloadData : event.getPayloadData()) {
                    BinaryMessageConverterUtil.assignData(aPayloadData, eventDataBuffer);
                }
            }
            if (event.getArbitraryDataMap() != null && event.getArbitraryDataMap().size() != 0) {
                for (Map.Entry<String, String> aArbitraryData : event.getArbitraryDataMap().entrySet()) {
                    BinaryMessageConverterUtil.assignData(aArbitraryData.getKey(), eventDataBuffer);
                    BinaryMessageConverterUtil.assignData(aArbitraryData.getValue(), eventDataBuffer);
                }
            }
            bytes.add(eventDataBuffer.array());
        }
        ByteBuffer buf = ByteBuffer.allocate(sessionId.length() + 13);
        buf.put((byte)2);
        buf.putInt(messageSize);
        buf.putInt(sessionId.length());
        buf.put(sessionId.getBytes("UTF-8"));
        buf.putInt(events.size());
        BufferedOutputStream outputstream = new BufferedOutputStream(socket.getOutputStream());
        ((OutputStream)outputstream).write(buf.array());
        for (byte[] byteArray : bytes) {
            ((OutputStream)outputstream).write(byteArray);
        }
        ((OutputStream)outputstream).flush();
    }

    private static int getEventSize(Event event) {
        int eventSize = 4 + event.getStreamId().length() + 8;
        Object[] data = event.getMetaData();
        if (data != null) {
            for (Object aData : data) {
                eventSize += BinaryMessageConverterUtil.getSize(aData);
            }
        }
        if ((data = event.getCorrelationData()) != null) {
            for (Object aData : data) {
                eventSize += BinaryMessageConverterUtil.getSize(aData);
            }
        }
        if ((data = event.getPayloadData()) != null) {
            for (Object aData : data) {
                eventSize += BinaryMessageConverterUtil.getSize(aData);
            }
        }
        if (event.getArbitraryDataMap() != null && event.getArbitraryDataMap().size() != 0) {
            for (Map.Entry<String, String> aArbitraryData : event.getArbitraryDataMap().entrySet()) {
                eventSize += 8 + aArbitraryData.getKey().length() + aArbitraryData.getValue().length();
            }
        }
        return eventSize;
    }

    public static String processResponse(Socket socket) throws Exception {
        InputStream inputStream = socket.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        int messageType = bufferedInputStream.read();
        switch (messageType) {
            case 0: {
                break;
            }
            case 1: {
                ByteBuffer bbuf = ByteBuffer.wrap(BinaryMessageConverterUtil.loadData(bufferedInputStream, new byte[8]));
                int errorClassNameLength = bbuf.getInt();
                int errorMsgLength = bbuf.getInt();
                String className = new String(ByteBuffer.wrap(BinaryMessageConverterUtil.loadData(bufferedInputStream, new byte[errorClassNameLength])).array());
                String errorMsg = new String(ByteBuffer.wrap(BinaryMessageConverterUtil.loadData(bufferedInputStream, new byte[errorMsgLength])).array());
                throw (Exception)BinaryDataEndpoint.class.getClassLoader().loadClass(className).getConstructor(String.class).newInstance(errorMsg);
            }
            case 2: {
                ByteBuffer bbuf = ByteBuffer.wrap(BinaryMessageConverterUtil.loadData(bufferedInputStream, new byte[4]));
                int sessionIdLength = bbuf.getInt();
                String sessionId = new String(ByteBuffer.wrap(BinaryMessageConverterUtil.loadData(bufferedInputStream, new byte[sessionIdLength])).array());
                return sessionId;
            }
        }
        return null;
    }
}

