/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.utils;

public class Tokenizer {
    private char[] value;
    private int max;
    private int cursor;

    public Tokenizer(String value) {
        this.value = value.toCharArray();
        this.max = this.value.length;
        this.cursor = 0;
    }

    private void skipWhiteSpace() {
        char c;
        int cur;
        char[] val = this.value;
        for (cur = this.cursor; cur < this.max && ((c = val[cur]) == ' ' || c == '\t' || c == '\n' || c == '\r'); ++cur) {
        }
        this.cursor = cur;
    }

    public String getToken(String terminals) {
        char c;
        int cur;
        this.skipWhiteSpace();
        char[] val = this.value;
        int begin = cur = this.cursor;
        while (cur < this.max && terminals.indexOf(c = val[cur]) == -1) {
            ++cur;
        }
        this.cursor = cur;
        int count = cur - begin;
        if (count > 0) {
            this.skipWhiteSpace();
            while (count > 0 && (val[begin + count - 1] == ' ' || val[begin + count - 1] == '\t')) {
                --count;
            }
            return new String(val, begin, count);
        }
        return null;
    }

    public String getString(String terminals, String preserveEscapes) {
        this.skipWhiteSpace();
        char[] val = this.value;
        int cur = this.cursor;
        if (cur < this.max) {
            if (val[cur] == '\"') {
                StringBuilder sb = new StringBuilder();
                char c = '\u0000';
                int begin = ++cur;
                while (cur < this.max) {
                    c = val[cur];
                    if (c == '\\') {
                        if (++cur == this.max) break;
                        c = val[cur];
                        if (preserveEscapes != null && preserveEscapes.indexOf(c) != -1) {
                            sb.append('\\');
                        }
                    } else if (c == '\"') break;
                    sb.append(c);
                    ++cur;
                }
                int count = cur - begin;
                if (c == '\"') {
                    ++cur;
                }
                this.cursor = cur;
                if (count > 0) {
                    this.skipWhiteSpace();
                    return sb.toString();
                }
            } else {
                return this.getToken(terminals);
            }
        }
        return null;
    }

    public String getString(String terminals) {
        return this.getString(terminals, null);
    }

    public char getChar() {
        int cur = this.cursor;
        if (cur < this.max) {
            this.cursor = cur + 1;
            return this.value[cur];
        }
        return '\u0000';
    }
}

