/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.common.disruptor.config;

import com.lmax.disruptor.RingBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisruptorConfig {
    private static Logger logger = LoggerFactory.getLogger(DisruptorConfig.class);
    private int bufferSize = 512;
    private int noDisruptors = 5;
    private int noOfEventHandlersPerDisruptor = 1;
    private int noOfThreadsInConsumerWorkerPool = 0;
    private String disruptorWaitStrategy = "PHASED_BACKOFF";
    private boolean notShared;
    private List<RingBuffer> disruptorMap = new ArrayList<RingBuffer>();
    private AtomicInteger index = new AtomicInteger(0);

    public DisruptorConfig() {
        logger.debug("Disruptor configration created with buffer size :=  " + this.bufferSize + " , no of disruptors :=" + this.noDisruptors + " , no of event handlers per disruptor := " + this.noOfEventHandlersPerDisruptor + ", wait strategy :=" + this.disruptorWaitStrategy);
    }

    public DisruptorConfig(String bufferSize, String noDisruptors, String noOfEventHandlersPerDisruptor, String disruptorWaitStrategy, boolean notShared, String noOfThreadsInConsumerWorkerPool) {
        if (bufferSize != null) {
            this.bufferSize = Integer.parseInt(bufferSize);
        }
        if (noDisruptors != null) {
            this.noDisruptors = Integer.parseInt(noDisruptors);
        }
        if (noOfEventHandlersPerDisruptor != null) {
            this.noOfEventHandlersPerDisruptor = Integer.parseInt(noOfEventHandlersPerDisruptor);
        }
        if (disruptorWaitStrategy != null) {
            this.disruptorWaitStrategy = disruptorWaitStrategy;
        }
        this.notShared = notShared;
        logger.debug("Disruptor configration created with buffer size :=  " + this.bufferSize + " , no of disruptors :=" + this.noDisruptors + " , no of event handlers per disruptor := " + this.noOfEventHandlersPerDisruptor + ", wait strategy :=" + this.disruptorWaitStrategy);
        if (noOfThreadsInConsumerWorkerPool != null) {
            this.noOfThreadsInConsumerWorkerPool = Integer.parseInt(noOfThreadsInConsumerWorkerPool);
            logger.debug(" Consumer pool with " + this.noOfThreadsInConsumerWorkerPool + " is used for Disruptor EventHandlers");
        } else {
            logger.debug("Worker Pool mode is disabled for Disruptor");
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getNoDisruptors() {
        return this.noDisruptors;
    }

    public int getNoOfEventHandlersPerDisruptor() {
        return this.noOfEventHandlersPerDisruptor;
    }

    public String getDisruptorWaitStrategy() {
        return this.disruptorWaitStrategy;
    }

    public boolean isShared() {
        return !this.notShared;
    }

    public RingBuffer getDisruptor() {
        int ind = this.index.getAndIncrement() % this.noDisruptors;
        return this.disruptorMap.get(ind);
    }

    public void addDisruptor(RingBuffer ringBuffer) {
        this.disruptorMap.add(ringBuffer);
    }

    public void notifyChannelInactive() {
        this.index.getAndDecrement();
    }

    public int getNoOfThreadsInConsumerWorkerPool() {
        return this.noOfThreadsInConsumerWorkerPool;
    }
}

