/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import com.lmax.disruptor.RingBuffer;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpRequest;
import java.util.EmptyStackException;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.FaultHandler;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.ChannelUtils;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class ClientRequestWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ClientRequestWorker.class);
    private ConnectionManager.PoolManagementPolicy poolManagementPolicy;
    private HttpRoute httpRoute;
    private SourceHandler sourceHandler;
    private SenderConfiguration senderConfig;
    private CarbonMessage carbonMessage;
    private HttpRequest httpRequest;
    private CarbonCallback carbonCallback;
    private GenericObjectPool genericObjectPool;
    private ConnectionManager connectionManager;
    private RingBuffer ringBuffer;
    private EventLoopGroup eventLoopGroup;
    private Class aClass;

    public ClientRequestWorker(HttpRoute httpRoute, SourceHandler sourceHandler, SenderConfiguration senderConfig, HttpRequest httpRequest, CarbonMessage carbonMessage, CarbonCallback carbonCallback, ConnectionManager.PoolManagementPolicy poolManagementPolicy, GenericObjectPool genericObjectPool, ConnectionManager connectionManager, RingBuffer ringBuffer, EventLoopGroup eventLoopGroup, Class aClass) {
        this.poolManagementPolicy = poolManagementPolicy;
        this.httpRequest = httpRequest;
        this.sourceHandler = sourceHandler;
        this.senderConfig = senderConfig;
        this.carbonCallback = carbonCallback;
        this.carbonMessage = carbonMessage;
        this.httpRoute = httpRoute;
        this.genericObjectPool = genericObjectPool;
        this.connectionManager = connectionManager;
        this.ringBuffer = ringBuffer;
        this.eventLoopGroup = eventLoopGroup;
        this.aClass = aClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        channel = null;
        targetChannel = null;
        if (this.poolManagementPolicy == ConnectionManager.PoolManagementPolicy.PER_SERVER_CHANNEL_ENDPOINT_CONNECTION_CACHING) {
            targetChannel = new TargetChannel();
            future = ChannelUtils.getNewChannelFuture(targetChannel, this.eventLoopGroup, this.aClass, this.httpRoute, this.senderConfig);
            try {
                channel = ChannelUtils.openChannel(future, this.httpRoute);
            }
            catch (Exception failedCause) {
                msg = "Error when creating channel for route " + this.httpRoute;
                ClientRequestWorker.log.error(msg);
                try {
                    faultHandler = this.carbonMessage.getFaultHandlerStack().pop();
                    targetChannel = null;
                    if (faultHandler == null) ** GOTO lbl30
                    faultHandler.handleFault("502", failedCause, this.carbonMessage, this.carbonCallback);
                    this.carbonMessage.getFaultHandlerStack().push(faultHandler);
                }
                catch (EmptyStackException e) {
                    ClientRequestWorker.log.error("Cannot find registered fault handler to process faulty message");
                }
            }
            finally {
                if (channel != null) {
                    targetChannel.setChannel(channel);
                    targetChannel.setTargetHandler(targetChannel.getNettyClientInitializer().getTargetHandler());
                }
            }
        } else {
            targetChannel = this.processThroughConnectionPool();
        }
lbl30:
        // 5 sources

        if (targetChannel != null) {
            targetChannel.setHttpRoute(this.httpRoute);
            if (targetChannel.getTargetHandler() == null) {
                ClientRequestWorker.log.error("Cannot find registered TargetHandler probably connection creation is failed");
                throw new RuntimeException("Connection creation failed for " + this.httpRoute.toString());
            }
            targetChannel.getTargetHandler().setCallback(this.carbonCallback);
            targetChannel.getTargetHandler().setIncomingMsg(this.carbonMessage);
            targetChannel.getTargetHandler().setRingBuffer(this.ringBuffer);
            targetChannel.getTargetHandler().setTargetChannel(targetChannel);
            targetChannel.getTargetHandler().setConnectionManager(this.connectionManager);
            written = false;
            if (targetChannel.getChannel() != null) {
                written = ChannelUtils.writeContent(targetChannel.getChannel(), this.httpRequest, this.carbonMessage);
            }
            if (written) {
                targetChannel.setRequestWritten(true);
            }
            if (this.sourceHandler != null) {
                targetChannel.setCorrelatedSource(this.sourceHandler);
                this.sourceHandler.addTargetChannel(this.httpRoute, targetChannel);
            }
        }
    }

    private TargetChannel processThroughConnectionPool() {
        try {
            Object obj = this.genericObjectPool.borrowObject();
            if (obj != null) {
                TargetChannel targetChannel = (TargetChannel)obj;
                targetChannel.setTargetHandler(targetChannel.getNettyClientInitializer().getTargetHandler());
                return targetChannel;
            }
        }
        catch (Exception e) {
            String msg = "Cannot borrow free channel from pool";
            log.error(msg, e);
            try {
                FaultHandler faultHandler = this.carbonMessage.getFaultHandlerStack().pop();
                if (faultHandler != null) {
                    faultHandler.handleFault("502", e, this.carbonMessage, this.carbonCallback);
                    this.carbonMessage.getFaultHandlerStack().push(faultHandler);
                }
            }
            catch (EmptyStackException e1) {
                log.error("Cannot find registered Fault handler to execute faulty message");
            }
        }
        return null;
    }
}

