/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapConfiguration.class);
    private static BootstrapConfiguration bootstrapConfig;
    private boolean tcpNoDelay = true;
    private int connectTimeOut = 15000;
    private int reciveBufferSize = 0x100000;
    private int sendBufferSize = 0x100000;
    private boolean keepAlive = true;
    private boolean socketReuse = false;
    private int socketTimeout = 15;

    private BootstrapConfiguration(Map<String, String> parameters) {
        if (parameters != null) {
            this.tcpNoDelay = parameters.get("client.bootstrap.nodelay") == null || Boolean.parseBoolean(parameters.get("client.bootstrap.nodelay"));
            this.connectTimeOut = parameters.get("client.bootstrap.connect.timeout") != null ? Integer.parseInt(parameters.get("client.bootstrap.connect.timeout")) : 15000;
            this.reciveBufferSize = parameters.get("client.bootstrap.recievebuffersize") != null ? Integer.parseInt(parameters.get("client.bootstrap.recievebuffersize")) : 0x100000;
            this.sendBufferSize = parameters.get("client.bootstrap.sendbuffersize") != null ? Integer.parseInt(parameters.get("client.bootstrap.sendbuffersize")) : 0x100000;
            this.socketTimeout = parameters.get("client.bootstrap.socket.timeout") != null ? Integer.parseInt(parameters.get("client.bootstrap.socket.timeout")) : 15;
            this.keepAlive = parameters.get("client.bootstrap.keepalive") == null || Boolean.parseBoolean(parameters.get("client.bootstrap.keepalive"));
            this.socketReuse = Boolean.parseBoolean(parameters.get("client.bootstrap.socket.reuse"));
        }
        logger.debug("client.bootstrap.nodelay: " + this.tcpNoDelay);
        logger.debug("client.bootstrap.connect.timeout:" + this.connectTimeOut);
        logger.debug("client.bootstrap.recievebuffersize:" + this.reciveBufferSize);
        logger.debug("client.bootstrap.sendbuffersize:" + this.sendBufferSize);
        logger.debug("client.bootstrap.socket.timeout:" + this.socketTimeout);
        logger.debug("client.bootstrap.keepalive:" + this.keepAlive);
        logger.debug("client.bootstrap.socket.reuse:" + this.socketReuse);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReciveBufferSize() {
        return this.reciveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public static BootstrapConfiguration getInstance() {
        return bootstrapConfig;
    }

    public static void createBootStrapConfiguration(Map<String, String> parameters) {
        bootstrapConfig = new BootstrapConfiguration(parameters);
    }
}

