/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.transaction;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.annotation.Timed;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.examples.petstore.util.JedisUtil;
import org.wso2.msf4j.examples.petstore.util.model.Order;

@HTTPMonitored
@Path(value="/transaction")
public class TxnService {
    private static final Logger log = LoggerFactory.getLogger(TxnService.class);

    @POST
    @Consumes(value={"application/json"})
    @Timed
    public Response addOrder(Order order) {
        String orderKey;
        String orderId = order.getId();
        if (!JedisUtil.smembers("petstore:transaction:orders").contains(orderId)) {
            JedisUtil.sadd("petstore:transaction:orders", orderId);
        }
        if (JedisUtil.get(orderKey = "petstore:transaction:order." + orderId) != null) {
            return Response.status(Response.Status.CONFLICT).entity("Order with ID " + orderId + " already exists").build();
        }
        JedisUtil.set(orderKey, new Gson().toJson(order));
        log.info("Added order");
        return Response.status(Response.Status.OK).entity(new Gson().toJson(orderId)).build();
    }

    @GET
    @Path(value="/all")
    @Produces(value={"application/json"})
    @Timed
    public List<Order> getOrders(String txnId) {
        Set<String> orderKeys = JedisUtil.smembers("petstore:transaction:orders");
        ArrayList<Order> result = new ArrayList<Order>(orderKeys.size());
        for (String orderKey : orderKeys) {
            String orderValue = JedisUtil.get(orderKey);
            result.add(new Gson().fromJson(orderValue, Order.class));
        }
        return result;
    }
}

