/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.InterceptorException;
import org.wso2.msf4j.internal.InterceptorExecutor;
import org.wso2.msf4j.internal.MicroservicesRegistry;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpMethodInfo;
import org.wso2.msf4j.internal.router.HttpMethodInfoBuilder;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.internal.router.PatternPathRouter;
import org.wso2.msf4j.util.HttpUtil;

@Component(name="org.wso2.msf4j.internal.MSF4JMessageProcessor", immediate=true, service={CarbonMessageProcessor.class})
public class MSF4JMessageProcessor
implements CarbonMessageProcessor {
    private static final Logger log = LoggerFactory.getLogger(MSF4JMessageProcessor.class);
    private MicroservicesRegistry microservicesRegistry;
    private static final String MSF4J_MSG_PROC_ID = "MSF4J-CM-PROCESSOR";

    public MSF4JMessageProcessor() {
    }

    public MSF4JMessageProcessor(MicroservicesRegistry microservicesRegistry) {
        this.microservicesRegistry = microservicesRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean receive(CarbonMessage carbonMessage, CarbonCallback carbonCallback) {
        if (this.microservicesRegistry == null) {
            this.microservicesRegistry = DataHolder.getInstance().getMicroservicesRegistry();
        }
        Request request = new Request(carbonMessage);
        Response response = new Response(carbonCallback);
        try {
            this.dispatchMethod(request, response);
        }
        catch (HandlerException e) {
            this.handleHandlerException(e, carbonCallback);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof HandlerException) {
                this.handleHandlerException((HandlerException)targetException, carbonCallback);
            } else {
                this.handleThrowable(targetException, carbonCallback);
            }
        }
        catch (InterceptorException e) {
            log.warn("Interceptors threw an exception", e);
            carbonCallback.done(HttpUtil.createTextResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ""));
        }
        catch (Throwable t) {
            this.handleThrowable(t, carbonCallback);
        }
        finally {
            carbonMessage.release();
        }
        return true;
    }

    private void dispatchMethod(Request request, Response response) throws Exception {
        HttpUtil.setConnectionHeader(request, response);
        PatternPathRouter.RoutableDestination<HttpResourceModel> destination = this.microservicesRegistry.getMetadata().getDestinationMethod(request.getUri(), request.getHttpMethod(), request.getContentType(), request.getAcceptTypes());
        HttpResourceModel resourceModel = destination.getDestination();
        response.setMediaType(this.getResponseType(request.getAcceptTypes(), resourceModel.getProducesMediaTypes()));
        InterceptorExecutor interceptorExecutor = new InterceptorExecutor(resourceModel, request, response, this.microservicesRegistry.getInterceptors());
        if (interceptorExecutor.execPreCalls()) {
            HttpMethodInfoBuilder httpMethodInfoBuilder = new HttpMethodInfoBuilder().httpResourceModel(resourceModel).httpRequest(request).httpResponder(response).requestInfo(destination.getGroupNameValues());
            HttpMethodInfo httpMethodInfo = httpMethodInfoBuilder.build();
            if (httpMethodInfo.isStreamingSupported()) {
                while (!request.isEmpty() || !request.isEomAdded()) {
                    httpMethodInfo.chunk(request.getMessageBody());
                }
                httpMethodInfo.end();
            } else {
                httpMethodInfo.invoke();
            }
            interceptorExecutor.execPostCalls(response.getStatusCode());
        }
    }

    private void handleThrowable(Throwable throwable, CarbonCallback carbonCallback) {
        Optional<ExceptionMapper> exceptionMapper = this.microservicesRegistry.getExceptionMapper(throwable);
        if (exceptionMapper.isPresent()) {
            Response msf4jResponse = new Response(carbonCallback);
            msf4jResponse.setEntity(exceptionMapper.get().toResponse(throwable));
            msf4jResponse.send();
        } else {
            log.warn("Unmapped exception", throwable);
            carbonCallback.done(HttpUtil.createTextResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Exception occurred :" + throwable.getMessage()));
        }
    }

    private void handleHandlerException(HandlerException e, CarbonCallback carbonCallback) {
        carbonCallback.done(e.getFailureResponse());
    }

    private String getResponseType(List<String> acceptTypes, List<String> producesMediaTypes) {
        String responseType = "*/*";
        if (!producesMediaTypes.contains("*/*") && acceptTypes != null) {
            responseType = acceptTypes.contains("*/*") ? producesMediaTypes.get(0) : producesMediaTypes.stream().filter(acceptTypes::contains).findFirst().get();
        } else if (acceptTypes == null && !producesMediaTypes.isEmpty()) {
            responseType = producesMediaTypes.get(0);
        }
        return responseType;
    }

    @Override
    public void setTransportSender(TransportSender transportSender) {
    }

    @Override
    public String getId() {
        return MSF4J_MSG_PROC_ID;
    }
}

