/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.msf4j.internal.router.ImmutablePair;

public final class PatternPathRouter<T> {
    private static final Pattern GROUP_PATTERN = Pattern.compile("\\{(.*?)\\}");
    private static final Pattern WILD_CARD_PATTERN = Pattern.compile("\\*\\*");
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("(\\w[-\\w\\.]*[ ]*)(\\:(.+))?");
    private static final String PATH_SLASH = "/";
    private final List<ImmutablePair<Pattern, RouteDestinationWithGroups>> patternRouteList = Lists.newArrayList();

    public static <T> PatternPathRouter<T> create() {
        return new PatternPathRouter<T>();
    }

    public void add(String source, T destination) {
        String path = source.replaceAll("/+", PATH_SLASH);
        path = path.endsWith(PATH_SLASH) && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
        String[] parts = path.split(PATH_SLASH);
        StringBuilder sb = new StringBuilder();
        ArrayList<String> groupNames = Lists.newArrayList();
        for (String part : parts) {
            Matcher groupMatcher = GROUP_PATTERN.matcher(part);
            if (groupMatcher.matches()) {
                PathPart pathPart = PatternPathRouter.createPathPart(groupMatcher.group(1));
                groupNames.add(pathPart.getName());
                if (pathPart.getPattern() != null) {
                    sb.append('(');
                    sb.append(pathPart.getPattern());
                    sb.append(')');
                } else {
                    sb.append("([^/]+?)");
                }
            } else if (WILD_CARD_PATTERN.matcher(part).matches()) {
                sb.append(".*?");
            } else {
                sb.append(part);
            }
            sb.append(PATH_SLASH);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        Pattern pattern = Pattern.compile(sb.toString());
        this.patternRouteList.add(ImmutablePair.of(pattern, new RouteDestinationWithGroups(destination, groupNames)));
    }

    private static PathPart createPathPart(String uriChunk) {
        PathPart pathPart = new PathPart();
        Matcher matcher = VARIABLE_PATTERN.matcher(uriChunk = PatternPathRouter.stripBraces(uriChunk).trim());
        if (matcher.matches()) {
            pathPart.setName(matcher.group(1).trim());
            if (matcher.group(2) != null && matcher.group(3) != null) {
                pathPart.setPattern(matcher.group(3).trim());
            }
        } else {
            pathPart.setName(uriChunk);
        }
        return pathPart;
    }

    private static String stripBraces(String token) {
        return token.charAt(0) == '{' && token.charAt(token.length() - 1) == '}' ? token.substring(1, token.length() - 1) : token;
    }

    public List<RoutableDestination<T>> getDestinations(String path) {
        String cleanPath = path.endsWith(PATH_SLASH) && path.length() > 0 ? path.substring(0, path.length() - 1) : path;
        ArrayList<RoutableDestination<T>> result = Lists.newArrayList();
        for (ImmutablePair<Pattern, RouteDestinationWithGroups> patternRoute : this.patternRouteList) {
            ImmutableMap.Builder<String, String> groupNameValuesBuilder = ImmutableMap.builder();
            Matcher matcher = patternRoute.getFirst().matcher(cleanPath);
            if (!matcher.matches()) continue;
            int matchIndex = 1;
            for (String name : patternRoute.getSecond().getGroupNames()) {
                String value = matcher.group(matchIndex);
                groupNameValuesBuilder.put(name, value);
                ++matchIndex;
            }
            result.add(new RoutableDestination(patternRoute.getSecond().getDestination(), groupNameValuesBuilder.build()));
        }
        return result;
    }

    private final class RouteDestinationWithGroups {
        private final T destination;
        private final List<String> groupNames;

        public RouteDestinationWithGroups(T destination, List<String> groupNames) {
            this.destination = destination;
            this.groupNames = groupNames;
        }

        public T getDestination() {
            return this.destination;
        }

        public List<String> getGroupNames() {
            return this.groupNames;
        }
    }

    public static final class RoutableDestination<T> {
        private final T destination;
        private final Map<String, String> groupNameValues;

        public RoutableDestination(T destination, Map<String, String> groupNameValues) {
            this.destination = destination;
            this.groupNameValues = groupNameValues;
        }

        public T getDestination() {
            return this.destination;
        }

        public Map<String, String> getGroupNameValues() {
            return this.groupNameValues;
        }

        public String toString() {
            return Objects.toStringHelper(this).add("destination", this.destination).add("groupNameValues", this.groupNameValues).toString();
        }
    }

    private static class PathPart {
        private String name;
        private String pattern;

        private PathPart() {
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

