/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config;

import java.util.Optional;
import java.util.function.Supplier;
import org.wso2.carbon.metrics.core.utils.Utils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public final class MetricsConfigBuilder {
    public static <T> T build(Class<T> clazz, Supplier<T> defaultConfig) {
        Optional<String> metricsConfigFileContent = Utils.readFile("metrics.conf", "metrics.yml");
        if (metricsConfigFileContent.isPresent()) {
            try {
                Representer representer = new Representer();
                representer.getPropertyUtils().setSkipMissingProperties(true);
                Yaml yaml = new Yaml(representer);
                return yaml.loadAs(metricsConfigFileContent.get(), clazz);
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed to populate Metrics Configuration", e);
            }
        }
        return defaultConfig.get();
    }
}

