/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.common;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.Header;
import org.wso2.carbon.messaging.Headers;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.Parameter;

public class Util {
    private static final String DEFAULT_HTTP_METHOD_POST = "POST";
    private static final String DEFAULT_VERSION_HTTP_1_1 = "HTTP/1.1";

    public static Headers getHeaders(HttpMessage message) {
        LinkedList<Header> headers = new LinkedList<Header>();
        if (message.headers() != null) {
            for (Map.Entry<String, String> k : message.headers().entries()) {
                headers.add(new Header(k.getKey(), k.getValue()));
            }
        }
        return new Headers(headers);
    }

    public static void setHeaders(HttpMessage message, Headers headers) {
        HttpHeaders httpHeaders = message.headers();
        for (Header header : headers.getAll()) {
            httpHeaders.add(header.getName(), (Object)header.getValue());
        }
    }

    public static String getStringValue(CarbonMessage msg, String key, String defaultValue) {
        String value = (String)msg.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static int getIntValue(CarbonMessage msg, String key, int defaultValue) {
        Integer value = (Integer)msg.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static HttpResponse createHttpResponse(CarbonMessage msg) {
        HttpVersion httpVersion = new HttpVersion(Util.getStringValue(msg, "HTTP_VERSION", HttpVersion.HTTP_1_1.text()), true);
        int statusCode = Util.getIntValue(msg, "HTTP_STATUS_CODE", 200);
        HttpResponseStatus httpResponseStatus = new HttpResponseStatus(statusCode, HttpResponseStatus.valueOf(statusCode).reasonPhrase());
        DefaultHttpResponse outgoingResponse = new DefaultHttpResponse(httpVersion, httpResponseStatus, false);
        Headers headers = msg.getHeaders();
        Util.setHeaders(outgoingResponse, headers);
        return outgoingResponse;
    }

    public static HttpRequest createHttpRequest(CarbonMessage msg) {
        HttpMethod httpMethod = null != msg.getProperty("HTTP_METHOD") ? new HttpMethod((String)msg.getProperty("HTTP_METHOD")) : new HttpMethod(DEFAULT_HTTP_METHOD_POST);
        HttpVersion httpVersion = null != msg.getProperty("HTTP_VERSION") ? new HttpVersion((String)msg.getProperty("HTTP_VERSION"), true) : new HttpVersion(DEFAULT_VERSION_HTTP_1_1, true);
        if ((String)msg.getProperty("TO") == null) {
            msg.setProperty("TO", "/");
        }
        DefaultHttpRequest outgoingRequest = new DefaultHttpRequest(httpVersion, httpMethod, (String)msg.getProperty("TO"), false);
        Headers headers = msg.getHeaders();
        Util.setHeaders(outgoingRequest, headers);
        return outgoingRequest;
    }

    public static SSLConfig getSSLConfigForListener(String certPass, String keyStorePass, String keyStoreFile, String trustStoreFile, String trustStorePass, List<Parameter> parametersList) {
        if (certPass == null) {
            certPass = keyStorePass;
        }
        if (keyStoreFile == null || keyStorePass == null) {
            throw new IllegalArgumentException("keyStoreFile or keyStorePass not defined for HTTPS scheme");
        }
        File keyStore = new File(keyStoreFile);
        if (!keyStore.exists()) {
            throw new IllegalArgumentException("KeyStore File " + keyStoreFile + " not found");
        }
        SSLConfig sslConfig = new SSLConfig(keyStore, keyStorePass).setCertPass(certPass);
        for (Parameter parameter : parametersList) {
            if (parameter.getName().equals("server.ssl.ciphers")) {
                sslConfig.setCipherSuites(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.ssl.http.protocols")) {
                sslConfig.setEnableProtocols(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.supported.snimatchers")) {
                sslConfig.setSniMatchers(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.suported.server.names")) {
                sslConfig.setServerNames(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("server.eanble.session.creation")) {
                sslConfig.setEnableSessionCreation(Boolean.parseBoolean(parameter.getValue()));
                continue;
            }
            if (!parameter.getName().equals("ssl.verify.client")) continue;
            sslConfig.setNeedClientAuth(Boolean.parseBoolean(parameter.getValue()));
        }
        if (trustStoreFile != null) {
            File trustStore = new File(trustStoreFile);
            if (!trustStore.exists()) {
                throw new IllegalArgumentException("trustStore File " + trustStoreFile + " not found");
            }
            if (trustStorePass == null) {
                throw new IllegalArgumentException("trustStorePass is not defined for HTTPS scheme");
            }
            sslConfig.setTrustStore(trustStore).setTrustStorePass(trustStorePass);
        }
        return sslConfig;
    }

    public static SSLConfig getSSLConfigForSender(String certPass, String keyStorePass, String keyStoreFile, String trustStoreFile, String trustStorePass, List<Parameter> parametersList) {
        if (certPass == null) {
            certPass = keyStorePass;
        }
        if (trustStoreFile == null || trustStorePass == null) {
            throw new IllegalArgumentException("TrusstoreFile or keyStorePass not defined for HTTPS scheme");
        }
        SSLConfig sslConfig = new SSLConfig(null, null).setCertPass(null);
        if (keyStoreFile != null) {
            File keyStore = new File(keyStoreFile);
            if (!keyStore.exists()) {
                throw new IllegalArgumentException("TrustStore File " + trustStoreFile + " not found");
            }
            sslConfig = new SSLConfig(keyStore, keyStorePass).setCertPass(certPass);
        }
        File trustStore = new File(trustStoreFile);
        sslConfig.setTrustStore(trustStore).setTrustStorePass(trustStorePass);
        sslConfig.setClientMode(true);
        for (Parameter parameter : parametersList) {
            if (parameter.getName().equals("client.ssl.ciphers")) {
                sslConfig.setCipherSuites(parameter.getValue());
                continue;
            }
            if (parameter.getName().equals("client.ssl.http.protocols")) {
                sslConfig.setEnableProtocols(parameter.getValue());
                continue;
            }
            if (!parameter.getName().equals("client.eanble.session.creation")) continue;
            sslConfig.setEnableSessionCreation(Boolean.parseBoolean(parameter.getValue()));
        }
        return sslConfig;
    }
}

