/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class YAMLTransportConfigurationBuilder {
    public static final String NETTY_TRANSPORT_CONF = "transports.netty.conf";

    public static TransportsConfiguration build() {
        TransportsConfiguration transportsConfiguration;
        block15: {
            String nettyTransportsConfigFile = System.getProperty(NETTY_TRANSPORT_CONF, "conf" + File.separator + "transports" + File.separator + "netty-transports.yml");
            File file = new File(nettyTransportsConfigFile);
            if (file.exists()) {
                try (InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.ISO_8859_1);){
                    Yaml yaml = new Yaml();
                    yaml.setBeanAccess(BeanAccess.FIELD);
                    TransportsConfiguration transportsConfiguration2 = yaml.loadAs(in, TransportsConfiguration.class);
                    break block15;
                }
                catch (IOException e) {
                    String msg = "Error while loading " + nettyTransportsConfigFile + " configuration file";
                    throw new RuntimeException(msg, e);
                }
            }
            transportsConfiguration = TransportsConfiguration.getDefault();
        }
        return transportsConfiguration;
    }
}

