/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine;

import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import org.wso2.carbon.deployment.engine.Artifact;

public class LifecycleEvent {
    private STATE state;
    private Artifact artifact;
    private Date timestamp;
    private RESULT deploymentResult;
    private String traceContent;
    public Properties properties = new Properties();

    public LifecycleEvent(Artifact artifact, Date date, STATE state) {
        this.artifact = artifact;
        this.deploymentResult = RESULT.SUCCESSFUL;
        this.timestamp = Optional.ofNullable(date).map(tstamp -> new Date(date.getTime())).orElse(new Date());
        this.state = state;
    }

    public STATE getState() {
        return this.state;
    }

    public void setState(STATE state) {
        this.state = state;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Date getTimestamp() {
        return new Date(Optional.of(this.timestamp).get().getTime());
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = new Date(timestamp.getTime());
    }

    public RESULT getDeploymentResult() {
        return this.deploymentResult;
    }

    public void setDeploymentResult(RESULT deploymentResult) {
        this.deploymentResult = deploymentResult;
    }

    public String getTraceContent() {
        return this.traceContent;
    }

    public void setTraceContent(String traceContent) {
        this.traceContent = traceContent;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public static enum RESULT {
        SUCCESSFUL,
        FAILED;

    }

    public static enum STATE {
        BEFORE_START_EVENT,
        AFTER_START_EVENT,
        BEFORE_UPDATE_EVENT,
        AFTER_UPDATE_EVENT,
        BEFORE_STOP_EVENT,
        AFTER_STOP_EVENT;

    }
}

