/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal;

import java.util.Collections;
import java.util.Set;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.carbon.messaging.handler.HandlerExecutor;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;
import org.wso2.carbon.transport.http.netty.config.TransportsConfiguration;
import org.wso2.carbon.transport.http.netty.config.YAMLTransportConfigurationBuilder;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.HTTPTransportListener;
import org.wso2.carbon.transport.http.netty.sender.HTTPSender;

public class HTTPTransportActivator
implements BundleActivator {
    public void start(BundleContext bundleContext) throws Exception {
        this.registerTransport(bundleContext);
        bundleContext.registerService(TransportSender.class, (Object)this.createClientBootstrapper(), null);
        HTTPTransportContextHolder.getInstance().setBundleContext(bundleContext);
        HandlerExecutor handlerExecutor = new HandlerExecutor();
        HTTPTransportContextHolder.getInstance().setHandlerExecutor(handlerExecutor);
    }

    private void registerTransport(BundleContext bundleContext) {
        TransportsConfiguration trpConfig = YAMLTransportConfigurationBuilder.build();
        Set<ListenerConfiguration> listenerConfigurations = trpConfig.getListenerConfigurations();
        Set<TransportProperty> transportProperties = trpConfig.getTransportProperties();
        listenerConfigurations.forEach(listenerConfiguration -> {
            HTTPTransportContextHolder.getInstance().setListenerConfiguration(listenerConfiguration.getId(), (ListenerConfiguration)listenerConfiguration);
            HTTPTransportListener httpTransportListener = new HTTPTransportListener(transportProperties, Collections.singleton(listenerConfiguration));
            bundleContext.registerService(CarbonTransport.class, (Object)httpTransportListener, null);
        });
    }

    private HTTPSender createClientBootstrapper() {
        TransportsConfiguration trpConfig = YAMLTransportConfigurationBuilder.build();
        Set<SenderConfiguration> senderConfigurations = trpConfig.getSenderConfigurations();
        Set<TransportProperty> transportProperties = trpConfig.getTransportProperties();
        HTTPSender sender = new HTTPSender(senderConfigurations, transportProperties);
        return sender;
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

