/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.TransportListener;
import org.wso2.carbon.messaging.TransportListenerManager;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.config.Parameter;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.CarbonHTTPServerInitializer;
import org.wso2.carbon.transport.http.netty.listener.ServerBootstrapConfiguration;

public class HTTPTransportListener
extends TransportListener {
    private static final Logger log = LoggerFactory.getLogger(HTTPTransportListener.class);
    private int bossGroupSize;
    private int workerGroupSize;
    private ServerBootstrap bootstrap;
    private ListenerConfiguration defaultListenerConfig;
    private Map<Integer, ChannelFuture> channelFutureMap = new ConcurrentHashMap<Integer, ChannelFuture>();
    private Map<String, ListenerConfiguration> listenerConfigurationMap = new HashMap<String, ListenerConfiguration>();
    private Map<String, ListenerConfiguration> listenerConfigMapWithPort = new HashMap<String, ListenerConfiguration>();
    private Map<String, SSLConfig> sslConfigMap = new ConcurrentHashMap<String, SSLConfig>();
    private Set<TransportProperty> transportProperties;

    public HTTPTransportListener(Set<TransportProperty> transportProperties, Set<ListenerConfiguration> listenerConfigurationSet) {
        super(listenerConfigurationSet.iterator().next().getId());
        if (listenerConfigurationSet.isEmpty()) {
            log.error("Cannot find registered listener configurations  hence cannot start the transport listeners");
            return;
        }
        this.transportProperties = transportProperties;
        for (TransportProperty property : transportProperties) {
            if (property.getName().equals("server.bootstrap.boss.group.size")) {
                this.bossGroupSize = (Integer)property.getValue();
                continue;
            }
            if (!property.getName().equals("server.bootstrap.worker.group.size")) continue;
            this.workerGroupSize = (Integer)property.getValue();
        }
        this.listenerConfigurationMap = listenerConfigurationSet.stream().collect(Collectors.toMap(ListenerConfiguration::getId, config -> config));
        listenerConfigurationSet.forEach(config -> {
            int port = config.getPort();
            String id = String.valueOf(port);
            this.listenerConfigMapWithPort.put(id, (ListenerConfiguration)config);
        });
        Iterator<ListenerConfiguration> itr = listenerConfigurationSet.iterator();
        if (itr.hasNext()) {
            this.defaultListenerConfig = itr.next();
        }
    }

    @Override
    public void start() {
        log.info("Starting  HTTP Transport Listener");
        this.startTransport();
    }

    private void startTransport() {
        TransportListenerManager transportListenerManager;
        EventLoopGroup workerGroup;
        ServerBootstrapConfiguration.createBootStrapConfiguration(this.transportProperties);
        ServerBootstrapConfiguration serverBootstrapConfiguration = ServerBootstrapConfiguration.getInstance();
        EventLoopGroup bossGroup = HTTPTransportContextHolder.getInstance().getBossGroup();
        if (bossGroup == null) {
            bossGroup = new NioEventLoopGroup(this.bossGroupSize != 0 ? this.bossGroupSize : Runtime.getRuntime().availableProcessors());
            HTTPTransportContextHolder.getInstance().setBossGroup(bossGroup);
        }
        if ((workerGroup = HTTPTransportContextHolder.getInstance().getWorkerGroup()) == null) {
            workerGroup = new NioEventLoopGroup(this.workerGroupSize != 0 ? this.workerGroupSize : Runtime.getRuntime().availableProcessors() * 2);
            HTTPTransportContextHolder.getInstance().setWorkerGroup(workerGroup);
        }
        log.debug("Netty Boss group size " + bossGroup);
        log.debug("Netty Worker group Size" + workerGroup);
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.option(ChannelOption.SO_BACKLOG, serverBootstrapConfiguration.getSoBackLog());
        log.debug("Netty Server Socket BACKLOG " + serverBootstrapConfiguration.getSoBackLog());
        this.bootstrap.group(bossGroup, workerGroup).channel(NioServerSocketChannel.class);
        this.addChannelInitializer();
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, serverBootstrapConfiguration.isTcpNoDelay());
        log.debug("Netty Server Socket TCP_NODELAY " + serverBootstrapConfiguration.isTcpNoDelay());
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, serverBootstrapConfiguration.isKeepAlive());
        log.debug("Netty Server Socket SO_KEEPALIVE " + serverBootstrapConfiguration.isKeepAlive());
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, serverBootstrapConfiguration.getConnectTimeOut());
        log.debug(" Netty Server Socket CONNECT_TIMEOUT_MILLIS " + serverBootstrapConfiguration.getConnectTimeOut());
        this.bootstrap.option(ChannelOption.SO_SNDBUF, serverBootstrapConfiguration.getSendBufferSize());
        log.debug("Netty Server Socket SO_SNDBUF " + serverBootstrapConfiguration.getSendBufferSize());
        this.bootstrap.option(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReciveBufferSize());
        log.debug("Netty Server Socket SO_RCVBUF " + serverBootstrapConfiguration.getReciveBufferSize());
        this.bootstrap.childOption(ChannelOption.SO_RCVBUF, serverBootstrapConfiguration.getReciveBufferSize());
        log.debug("Netty Server Socket SO_RCVBUF " + serverBootstrapConfiguration.getReciveBufferSize());
        this.bootstrap.childOption(ChannelOption.SO_SNDBUF, serverBootstrapConfiguration.getSendBufferSize());
        log.debug("Netty Server Socket SO_SNDBUF " + serverBootstrapConfiguration.getSendBufferSize());
        if (this.defaultListenerConfig.isBindOnStartup()) {
            this.bindInterface(this.defaultListenerConfig);
        }
        if ((transportListenerManager = HTTPTransportContextHolder.getInstance().getManager()) != null) {
            transportListenerManager.registerTransportListener(this);
        }
    }

    private void addChannelInitializer() {
        CarbonHTTPServerInitializer handler = new CarbonHTTPServerInitializer(this.listenerConfigMapWithPort);
        handler.setSslConfig(this.defaultListenerConfig.getSslConfig());
        handler.setSslConfigMap(this.sslConfigMap);
        List<Parameter> parameters = this.defaultListenerConfig.getParameters();
        Map<String, String> paramMap = new HashMap<String, String>();
        if (parameters != null && !parameters.isEmpty()) {
            paramMap = parameters.stream().collect(Collectors.toMap(Parameter::getName, Parameter::getValue));
        }
        handler.setup(paramMap);
        handler.setup(this.transportProperties);
        this.bootstrap.childHandler(handler);
    }

    @Override
    public void stop() {
        log.info("Stopping HTTP transport " + this.id + " on port " + this.defaultListenerConfig.getPort());
        this.shutdownEventLoops();
    }

    @Override
    public void beginMaintenance() {
        log.info("Putting HTTP transport " + this.id + " on port " + this.defaultListenerConfig.getPort() + " into maintenance mode");
        this.shutdownEventLoops();
    }

    @Override
    public void endMaintenance() {
        log.info("Ending maintenance mode for HTTP transport " + this.id + " running on port " + this.defaultListenerConfig.getPort());
        HTTPTransportContextHolder.getInstance().setBossGroup(new NioEventLoopGroup(this.bossGroupSize != 0 ? this.bossGroupSize : Runtime.getRuntime().availableProcessors()));
        HTTPTransportContextHolder.getInstance().setWorkerGroup(new NioEventLoopGroup(this.workerGroupSize != 0 ? this.workerGroupSize : Runtime.getRuntime().availableProcessors()));
        this.startTransport();
    }

    private void shutdownEventLoops() {
        try {
            EventLoopGroup workerGroup;
            EventLoopGroup bossGroup = HTTPTransportContextHolder.getInstance().getBossGroup();
            if (bossGroup != null) {
                bossGroup.shutdownGracefully().sync();
                HTTPTransportContextHolder.getInstance().setBossGroup(null);
            }
            if ((workerGroup = HTTPTransportContextHolder.getInstance().getWorkerGroup()) != null) {
                workerGroup.shutdownGracefully().sync();
                HTTPTransportContextHolder.getInstance().setWorkerGroup(null);
            }
            log.info("HTTP transport " + this.id + " on port " + this.defaultListenerConfig.getPort() + " stopped successfully");
        }
        catch (InterruptedException e) {
            log.error("HTTP transport " + this.id + " on port " + this.defaultListenerConfig.getPort() + " could not be stopped successfully " + e.getMessage());
        }
    }

    @Override
    public void setMessageProcessor(CarbonMessageProcessor carbonMessageProcessor) {
    }

    @Override
    public boolean bind(String interfaceId) {
        ListenerConfiguration listenerConfiguration = this.listenerConfigurationMap.get(interfaceId);
        if (listenerConfiguration != null) {
            if (!listenerConfiguration.isBindOnStartup()) {
                return this.bindInterface(listenerConfiguration);
            }
            log.debug("Interface is already binned at the startup, hence ignoring");
            return true;
        }
        log.error("Cannot find defined Listener interface  for Listener id " + interfaceId);
        return false;
    }

    private boolean bindInterface(ListenerConfiguration listenerConfiguration) {
        try {
            ChannelFuture future;
            String id = String.valueOf(listenerConfiguration.getPort());
            SSLConfig sslConfig = listenerConfiguration.getSslConfig();
            if (sslConfig != null) {
                this.sslConfigMap.put(id, sslConfig);
            }
            if ((future = this.bootstrap.bind(new InetSocketAddress(listenerConfiguration.getHost(), listenerConfiguration.getPort())).sync()).isSuccess()) {
                this.channelFutureMap.put(listenerConfiguration.getPort(), future);
                if (listenerConfiguration.getSslConfig() == null) {
                    log.info("HTTP Interface " + listenerConfiguration.getId() + " starting on host  " + listenerConfiguration.getHost() + " and port " + listenerConfiguration.getPort());
                } else {
                    log.info("HTTPS Interface " + listenerConfiguration.getId() + " starting on host  " + listenerConfiguration.getHost() + " and port " + listenerConfiguration.getPort());
                }
                return true;
            }
            log.error("Cannot bind port for host " + listenerConfiguration.getHost() + " port " + listenerConfiguration.getPort());
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), e);
        }
        return false;
    }

    @Override
    public boolean unBind(String interfaceId) {
        ListenerConfiguration listenerConfiguration = this.listenerConfigurationMap.get(interfaceId);
        if (listenerConfiguration != null && !this.defaultListenerConfig.getId().equals(listenerConfiguration.getId())) {
            String id = String.valueOf(listenerConfiguration.getPort());
            ChannelFuture future = this.channelFutureMap.remove(listenerConfiguration.getPort());
            if (future != null) {
                if (this.sslConfigMap.get(id) != null) {
                    this.sslConfigMap.remove(id);
                }
                future.channel().close();
                if (listenerConfiguration.getSslConfig() == null) {
                    log.info("HTTP Listener stopped on listening interface " + interfaceId + " attached to   host  " + listenerConfiguration.getHost() + " and port " + listenerConfiguration.getPort());
                } else {
                    log.info("HTTPS Listener stopped on listening interface " + interfaceId + " attached to   host  " + listenerConfiguration.getHost() + " and port " + listenerConfiguration.getPort());
                }
                return true;
            }
        }
        return false;
    }
}

