/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.ResponseCallback;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class SourceHandler
extends ChannelInboundHandlerAdapter {
    private static Logger log = LoggerFactory.getLogger(SourceHandler.class);
    protected ChannelHandlerContext ctx;
    protected HTTPCarbonMessage cMsg;
    protected ConnectionManager connectionManager;
    private Map<String, TargetChannel> channelFutureMap = new HashMap<String, TargetChannel>();
    protected Map<String, GenericObjectPool> targetChannelPool;
    protected ListenerConfiguration listenerConfiguration;

    public ListenerConfiguration getListenerConfiguration() {
        return this.listenerConfiguration;
    }

    public SourceHandler(ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration) throws Exception {
        this.listenerConfiguration = listenerConfiguration;
        this.connectionManager = connectionManager;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        this.ctx = ctx;
        this.targetChannelPool = this.connectionManager.getTargetChannelPool();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            this.publishToMessageProcessor(msg);
            ByteBuf content = ((FullHttpMessage)msg).content();
            this.cMsg.addHttpContent(new DefaultLastHttpContent(content));
            this.cMsg.setEndOfMsgAdded(true);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(this.cMsg);
            }
        } else if (msg instanceof HttpRequest) {
            this.publishToMessageProcessor(msg);
        } else if (this.cMsg != null && msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            this.cMsg.addHttpContent(httpContent);
            if (msg instanceof LastHttpContent) {
                this.cMsg.setEndOfMsgAdded(true);
                if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(this.cMsg);
                }
            }
        }
    }

    private void publishToMessageProcessor(Object msg) {
        this.cMsg = (HTTPCarbonMessage)this.setupCarbonMessage(msg);
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(this.cMsg);
        }
        boolean continueRequest = true;
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            continueRequest = HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeRequestContinuationValidator(this.cMsg, carbonMessage -> {
                CarbonCallback responseCallback = (CarbonCallback)this.cMsg.getProperty("CALL_BACK");
                responseCallback.done(carbonMessage);
            });
        }
        if (continueRequest) {
            CarbonMessageProcessor carbonMessageProcessor = HTTPTransportContextHolder.getInstance().getMessageProcessor();
            if (carbonMessageProcessor != null) {
                try {
                    carbonMessageProcessor.receive(this.cMsg, new ResponseCallback(this.ctx));
                }
                catch (Exception e) {
                    log.error("Error while submitting CarbonMessage to CarbonMessageProcessor", e);
                }
            } else {
                log.error("Cannot find registered MessageProcessor for forward the message");
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
        this.connectionManager.notifyChannelInactive();
    }

    public void addTargetChannel(HttpRoute route, TargetChannel targetChannel) {
        this.channelFutureMap.put(route.toString(), targetChannel);
    }

    public void removeChannelFuture(HttpRoute route) {
        log.debug("Removing channel future from map");
        this.channelFutureMap.remove(route.toString());
    }

    public TargetChannel getChannel(HttpRoute route) {
        return this.channelFutureMap.get(route.toString());
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx != null && ctx.channel().isActive()) {
            ctx.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    protected CarbonMessage setupCarbonMessage(Object msg) {
        this.cMsg = new HTTPCarbonMessage();
        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(this.cMsg);
        }
        this.cMsg.setProperty("PORT", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("HOST", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        HttpRequest httpRequest = (HttpRequest)msg;
        this.cMsg.setProperty("TO", httpRequest.getUri());
        this.cMsg.setProperty("CHNL_HNDLR_CTX", this.ctx);
        this.cMsg.setProperty("SRC_HNDLR", this);
        this.cMsg.setProperty("HTTP_VERSION", httpRequest.getProtocolVersion().text());
        this.cMsg.setProperty("HTTP_METHOD", httpRequest.getMethod().name());
        this.cMsg.setProperty("LISTENER_PORT", ((InetSocketAddress)this.ctx.channel().localAddress()).getPort());
        this.cMsg.setProperty("LISTENER_INTERFACE_ID", this.listenerConfiguration.getId());
        this.cMsg.setProperty("PROTOCOL", "http");
        if (this.listenerConfiguration.getSslConfig() != null) {
            this.cMsg.setProperty("IS_SECURED_CONNECTION", true);
        } else {
            this.cMsg.setProperty("IS_SECURED_CONNECTION", false);
        }
        this.cMsg.setProperty("LOCAL_ADDRESS", this.ctx.channel().localAddress());
        this.cMsg.setProperty("LOCAL_NAME", ((InetSocketAddress)this.ctx.channel().localAddress()).getHostName());
        this.cMsg.setProperty("REMOTE_ADDRESS", this.ctx.channel().remoteAddress());
        this.cMsg.setProperty("REMOTE_HOST", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        this.cMsg.setProperty("REMOTE_PORT", ((InetSocketAddress)this.ctx.channel().remoteAddress()).getPort());
        this.cMsg.setProperty("REQUEST_URL", httpRequest.getUri());
        ChannelHandler handler = this.ctx.handler();
        this.cMsg.setProperty("CHANNEL_ID", ((SourceHandler)handler).getListenerConfiguration().getId());
        this.cMsg.setHeaders(Util.getHeaders(httpRequest).getAll());
        return this.cMsg;
    }
}

