/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.config.RequestSizeValidationConfiguration;

public class CustomHttpRequestDecoder
extends HttpRequestDecoder {
    private static final Logger log = LoggerFactory.getLogger(CustomHttpRequestDecoder.class);

    public CustomHttpRequestDecoder() {
        super(RequestSizeValidationConfiguration.getInstance().getHeaderMaxRequestLineSize(), RequestSizeValidationConfiguration.getInstance().getHeaderMaxSize(), RequestSizeValidationConfiguration.getInstance().getMaxChunkSize(), true);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        super.decode(ctx, buffer, out);
        for (Object o : out) {
            DefaultHttpRequest httpRequest;
            if (!(o instanceof DefaultHttpRequest) || !(httpRequest = (DefaultHttpRequest)o).getDecoderResult().isFailure() || !(httpRequest.getDecoderResult().cause() instanceof TooLongFrameException)) continue;
            log.warn("Header size is larger than the valid limit");
            Iterator iterator = ctx.pipeline().iterator();
            boolean canRemove = false;
            while (iterator.hasNext()) {
                Map.Entry channelHandlerEntry = (Map.Entry)iterator.next();
                if (((String)channelHandlerEntry.getKey()).equalsIgnoreCase(ctx.name())) {
                    canRemove = true;
                }
                if (!canRemove || ((String)channelHandlerEntry.getKey()).equalsIgnoreCase(ctx.name())) continue;
                ctx.pipeline().remove((String)channelHandlerEntry.getKey());
            }
            String rejectMessage = RequestSizeValidationConfiguration.getInstance().getHeaderRejectMessage();
            byte[] errorMessageBytes = rejectMessage.getBytes(Charset.defaultCharset());
            ByteBuf content = Unpooled.wrappedBuffer(errorMessageBytes);
            DefaultFullHttpResponse rejectResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(RequestSizeValidationConfiguration.getInstance().getHeaderRejectStatusCode()), content);
            rejectResponse.headers().set("Content-Length", (Object)errorMessageBytes.length);
            rejectResponse.headers().set("Content-Type", (Object)RequestSizeValidationConfiguration.getInstance().getHeaderRejectMsgContentType());
            ctx.writeAndFlush(rejectResponse);
            break;
        }
    }
}

