/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.messaging.MessageDataSource;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.internal.HTTPTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.http2.HTTP2SourceHandler;
import org.wso2.carbon.transport.http.netty.message.HTTPCarbonMessage;

public class HTTP2ResponseCallback
implements CarbonCallback {
    private ChannelHandlerContext ctx;
    private int streamId;
    private static final Logger logger = LoggerFactory.getLogger(HTTP2ResponseCallback.class);
    private static final String DEFAULT_HTTP_METHOD_POST = "POST";

    public HTTP2ResponseCallback(ChannelHandlerContext channelHandlerContext, int streamId) {
        this.ctx = channelHandlerContext;
        this.streamId = streamId;
    }

    @Override
    public void done(CarbonMessage cMsg) {
        block14: {
            this.handleResponsesWithoutContentLength(cMsg);
            if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseReceiving(cMsg);
            }
            Http2Headers http2Headers = this.createHttp2Headers(cMsg);
            if (this.ctx.handler() instanceof HTTP2SourceHandler) {
                HTTP2SourceHandler http2SourceHandler = (HTTP2SourceHandler)this.ctx.handler();
                http2SourceHandler.encoder().writeHeaders(this.ctx, this.streamId, http2Headers, 0, false, this.ctx.newPromise());
                try {
                    if (cMsg instanceof HTTPCarbonMessage) {
                        HTTPCarbonMessage nettyCMsg = (HTTPCarbonMessage)cMsg;
                        while (true) {
                            if (nettyCMsg.isEndOfMsgAdded() && nettyCMsg.isEmpty()) {
                                http2SourceHandler.encoder().writeData(this.ctx, this.streamId, Unpooled.EMPTY_BUFFER, 0, true, this.ctx.newPromise());
                                http2SourceHandler.flush(this.ctx);
                                break block14;
                            }
                            HttpContent httpContent = nettyCMsg.getHttpContent();
                            if (httpContent instanceof LastHttpContent) {
                                http2SourceHandler.encoder().writeData(this.ctx, this.streamId, httpContent.content(), 0, true, this.ctx.newPromise());
                                http2SourceHandler.flush(this.ctx);
                                if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                                    HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(cMsg);
                                }
                                break block14;
                            }
                            http2SourceHandler.encoder().writeData(this.ctx, this.streamId, httpContent.content(), 0, false, this.ctx.newPromise());
                        }
                    }
                    if (cMsg instanceof DefaultCarbonMessage) {
                        String connection;
                        DefaultCarbonMessage defaultCMsg = (DefaultCarbonMessage)cMsg;
                        if (defaultCMsg.isEndOfMsgAdded() && defaultCMsg.isEmpty()) {
                            http2SourceHandler.encoder().writeData(this.ctx, this.streamId, Unpooled.EMPTY_BUFFER, 0, true, this.ctx.newPromise());
                            http2SourceHandler.flush(this.ctx);
                            return;
                        }
                        do {
                            ByteBuffer byteBuffer = defaultCMsg.getMessageBody();
                            ByteBuf bbuf = Unpooled.wrappedBuffer(byteBuffer);
                            http2SourceHandler.encoder().writeData(this.ctx, this.streamId, bbuf, 0, false, this.ctx.newPromise());
                        } while (!defaultCMsg.isEndOfMsgAdded() || !defaultCMsg.isEmpty());
                        ChannelFuture future = http2SourceHandler.encoder().writeData(this.ctx, this.streamId, Unpooled.EMPTY_BUFFER, 0, true, this.ctx.newPromise());
                        http2SourceHandler.flush(this.ctx);
                        if (HTTPTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                            HTTPTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceResponseSending(cMsg);
                        }
                        if ((connection = cMsg.getHeader("Connection")) != null && "close".equalsIgnoreCase(connection)) {
                            future.addListener(ChannelFutureListener.CLOSE);
                        }
                    }
                }
                catch (Http2Exception e) {
                    logger.error("Error occurred while sending response to client", e);
                }
            }
        }
    }

    private void handleResponsesWithoutContentLength(CarbonMessage cMsg) {
        if (cMsg.isAlreadyRead()) {
            MessageDataSource messageDataSource = cMsg.getMessageDataSource();
            if (messageDataSource != null) {
                messageDataSource.serializeData();
                cMsg.setEndOfMsgAdded(true);
                cMsg.getHeaders().remove("Content-Length");
            } else {
                logger.error("Message is already built but cannot find the MessageDataSource");
            }
        }
        if (cMsg.getHeader("Transfer-Encoding") == null && cMsg.getHeader("Content-Length") == null) {
            cMsg.setHeader("Content-Length", String.valueOf(cMsg.getFullMessageLength()));
        }
    }

    private Http2Headers createHttp2Headers(CarbonMessage msg) {
        Http2Headers http2Headers = new DefaultHttp2Headers().status(String.valueOf(Util.getIntValue(msg, "HTTP_STATUS_CODE", 200))).method(Util.getStringValue(msg, "HTTP_METHOD", DEFAULT_HTTP_METHOD_POST)).path(msg.getProperty("TO") != null ? msg.getProperty("TO").toString() : "/").scheme(msg.getProperty("SCHEME") != null ? msg.getProperty("SCHEME").toString() : "http");
        if (msg.getProperty("AUTHORITY") != null) {
            http2Headers.authority("AUTHORITY");
        } else {
            http2Headers.authority(((InetSocketAddress)this.ctx.channel().remoteAddress()).getHostName());
        }
        msg.getHeaders().getAll().forEach(k -> {
            Http2Headers cfr_ignored_0 = (Http2Headers)http2Headers.add(k.getName().toLowerCase(), k.getValue());
        });
        return http2Headers;
    }
}

