/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.message;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.transport.http.netty.listener.ServerBootstrapConfiguration;
import org.wso2.carbon.transport.http.netty.message.EmptyLastHttpContent;
import org.wso2.carbon.transport.http.netty.sender.channel.BootstrapConfiguration;

public class HTTPCarbonMessage
extends CarbonMessage {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPCarbonMessage.class);
    private BlockingQueue<HttpContent> httpContentQueue = new LinkedBlockingQueue<HttpContent>();
    private BlockingQueue<HttpContent> outContentQueue = new LinkedBlockingQueue<HttpContent>();
    private BlockingQueue<HttpContent> garbageCollected = new LinkedBlockingQueue<HttpContent>();
    private boolean isEndMarked = false;
    private int soTimeOut = 60;

    public HTTPCarbonMessage() {
        BootstrapConfiguration clientBootstrapConfig = BootstrapConfiguration.getInstance();
        if (clientBootstrapConfig != null) {
            this.soTimeOut = clientBootstrapConfig.getSocketTimeout();
            return;
        }
        ServerBootstrapConfiguration serverBootstrapConfiguration = ServerBootstrapConfiguration.getInstance();
        if (serverBootstrapConfiguration != null) {
            this.soTimeOut = serverBootstrapConfiguration.getSoTimeOut();
        }
    }

    public void addHttpContent(HttpContent httpContent) {
        try {
            this.httpContentQueue.put(httpContent);
        }
        catch (InterruptedException e) {
            LOG.error("Cannot put content to queue", e);
        }
    }

    public HttpContent getHttpContent() {
        try {
            return this.httpContentQueue.poll(this.soTimeOut, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Error while retrieving http content from queue.", e);
            return null;
        }
    }

    @Override
    public ByteBuffer getMessageBody() {
        try {
            HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.SECONDS);
            if (httpContent instanceof LastHttpContent) {
                super.setEndOfMsgAdded(true);
            }
            ByteBuf buf = httpContent.content();
            this.garbageCollected.add(httpContent);
            return buf.nioBuffer();
        }
        catch (InterruptedException e) {
            LOG.error("Error while retrieving message body from queue.", e);
            return null;
        }
    }

    @Override
    public List<ByteBuffer> getFullMessageBody() {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        boolean isEndOfMessageProcessed = false;
        while (!isEndOfMessageProcessed) {
            try {
                HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.SECONDS);
                if (httpContent instanceof EmptyLastHttpContent) break;
                if (httpContent instanceof LastHttpContent) {
                    isEndOfMessageProcessed = true;
                }
                ByteBuf buf = httpContent.content();
                this.garbageCollected.add(httpContent);
                byteBufferList.add(buf.nioBuffer());
            }
            catch (InterruptedException e) {
                LOG.error("Error while getting full message body", e);
            }
        }
        return byteBufferList;
    }

    @Override
    public InputStream getInputStream() {
        String contentEncodingHeader = this.getHeader("Content-Encoding");
        if (contentEncodingHeader != null) {
            this.removeHeader("Content-Encoding");
            try {
                if (contentEncodingHeader.equalsIgnoreCase("gzip")) {
                    return new GZIPInputStream(super.getInputStream());
                }
                if (contentEncodingHeader.equalsIgnoreCase("deflate")) {
                    return new InflaterInputStream(super.getInputStream());
                }
                LOG.warn("Unknown Content-Encoding: " + contentEncodingHeader);
            }
            catch (IOException e) {
                LOG.error("Error while creating inputStream for content-encoding: " + contentEncodingHeader, e);
            }
        }
        return super.getInputStream();
    }

    @Override
    public boolean isEmpty() {
        return this.httpContentQueue.isEmpty();
    }

    @Override
    public int getFullMessageLength() {
        ArrayList<HttpContent> contentList = new ArrayList<HttpContent>();
        boolean isEndOfMessageProcessed = false;
        while (!isEndOfMessageProcessed) {
            try {
                HttpContent httpContent = this.httpContentQueue.poll(this.soTimeOut, TimeUnit.SECONDS);
                if (httpContent instanceof LastHttpContent || this.isEndOfMsgAdded() && this.httpContentQueue.isEmpty()) {
                    isEndOfMessageProcessed = true;
                }
                contentList.add(httpContent);
            }
            catch (InterruptedException e) {
                LOG.error("Error while getting full message length", e);
            }
        }
        int size = 0;
        for (HttpContent httpContent : contentList) {
            size += httpContent.content().readableBytes();
            this.httpContentQueue.add(httpContent);
        }
        return size;
    }

    @Override
    public boolean isEndOfMsgAdded() {
        return super.isEndOfMsgAdded();
    }

    @Override
    public void addMessageBody(ByteBuffer msgBody) {
        if (this.isAlreadyRead()) {
            this.outContentQueue.add(new DefaultHttpContent(Unpooled.copiedBuffer(msgBody)));
        } else {
            this.httpContentQueue.add(new DefaultHttpContent(Unpooled.copiedBuffer(msgBody)));
        }
    }

    @Override
    public void markMessageEnd() {
        if (this.isAlreadyRead()) {
            this.outContentQueue.add(new EmptyLastHttpContent());
        } else {
            this.httpContentQueue.add(new EmptyLastHttpContent());
        }
    }

    @Override
    public void setEndOfMsgAdded(boolean endOfMsgAdded) {
        super.setEndOfMsgAdded(endOfMsgAdded);
        if (this.isAlreadyRead()) {
            this.outContentQueue.forEach(buffer -> this.httpContentQueue.add((HttpContent)buffer));
            this.outContentQueue.clear();
        }
    }

    @Override
    public void release() {
        this.httpContentQueue.forEach(content -> content.release());
        this.garbageCollected.forEach(content -> content.release());
    }
}

