/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.websocket.CloseReason;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.messaging.BinaryCarbonMessage;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.CarbonMessageProcessor;
import org.wso2.carbon.messaging.ClientConnector;
import org.wso2.carbon.messaging.ControlCarbonMessage;
import org.wso2.carbon.messaging.DefaultCarbonMessage;
import org.wso2.carbon.messaging.StatusCarbonMessage;
import org.wso2.carbon.messaging.TextCarbonMessage;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.config.MSF4JConfig;
import org.wso2.msf4j.delegates.MSF4JResponse;
import org.wso2.msf4j.interceptor.InterceptorExecutor;
import org.wso2.msf4j.internal.DataHolder;
import org.wso2.msf4j.internal.MSF4JThreadFactory;
import org.wso2.msf4j.internal.MicroservicesRegistryImpl;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpMethodInfo;
import org.wso2.msf4j.internal.router.HttpMethodInfoBuilder;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.internal.router.PatternPathRouter;
import org.wso2.msf4j.internal.router.Util;
import org.wso2.msf4j.internal.websocket.CloseCodeImpl;
import org.wso2.msf4j.internal.websocket.EndpointDispatcher;
import org.wso2.msf4j.internal.websocket.EndpointsRegistryImpl;
import org.wso2.msf4j.internal.websocket.WebSocketPongMessage;
import org.wso2.msf4j.util.HttpUtil;
import org.wso2.msf4j.websocket.exception.WebSocketEndpointAnnotationException;
import org.wso2.msf4j.websocket.exception.WebSocketEndpointMethodReturnTypeException;

public class MSF4JMessageProcessor
implements CarbonMessageProcessor {
    private static final Logger log = LoggerFactory.getLogger(MSF4JMessageProcessor.class);
    private static final String MSF4J_MSG_PROC_ID = "MSF4J-CM-PROCESSOR";
    private ExecutorService executorService;

    public MSF4JMessageProcessor() {
        MSF4JConfig msf4JConfig;
        ConfigProvider configProvider = DataHolder.getInstance().getConfigProvider();
        if (configProvider == null) {
            if (DataHolder.getInstance().getBundleContext() != null) {
                throw new RuntimeException("Failed to populate MSF4J Configuration. Config Provider is Null.");
            }
            String deploymentYamlPath = System.getProperty("msf4j.conf");
            try {
                if (deploymentYamlPath != null && Files.exists(Paths.get(deploymentYamlPath, new String[0]), new LinkOption[0])) {
                    configProvider = ConfigProviderFactory.getConfigProvider(Paths.get(deploymentYamlPath, new String[0]), null);
                    DataHolder.getInstance().setConfigProvider(configProvider);
                } else {
                    log.warn("MSF4J Configuration file is not provided. either system property 'msf4j.conf' is not set or provided file path not exist. Hence using default configuration.");
                }
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Error loading deployment.yaml Configuration", e);
            }
        }
        try {
            msf4JConfig = configProvider != null ? DataHolder.getInstance().getConfigProvider().getConfigurationObject(MSF4JConfig.class) : (MSF4JConfig)MSF4JConfig.class.newInstance();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Error while loading " + MSF4JConfig.class.getName() + " from config provider", e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error while creating instance of the class " + MSF4JConfig.class.getName(), e);
        }
        this.executorService = Executors.newFixedThreadPool(msf4JConfig.getThreadCount(), new MSF4JThreadFactory(new ThreadGroup(msf4JConfig.getThreadPoolName())));
    }

    public MSF4JMessageProcessor(String channelId, MicroservicesRegistryImpl microservicesRegistry) {
        DataHolder.getInstance().getMicroservicesRegistries().put(channelId, microservicesRegistry);
    }

    @Override
    public boolean receive(CarbonMessage carbonMessage, CarbonCallback carbonCallback) {
        this.executorService.execute(() -> {
            String protocolName = (String)carbonMessage.getProperty("PROTOCOL");
            if ("http".equalsIgnoreCase(protocolName)) {
                MicroservicesRegistryImpl currentMicroservicesRegistry = DataHolder.getInstance().getMicroservicesRegistries().get(carbonMessage.getProperty("CHANNEL_ID"));
                Request request = new Request(carbonMessage);
                request.setSessionManager(currentMicroservicesRegistry.getSessionManager());
                this.setBaseUri(request);
                Response response = new Response(carbonCallback, request);
                try {
                    this.dispatchMethod(currentMicroservicesRegistry, request, response);
                }
                catch (HandlerException e) {
                    this.handleHandlerException(e, carbonCallback);
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    if (targetException instanceof HandlerException) {
                        this.handleHandlerException((HandlerException)targetException, carbonCallback);
                    }
                    this.handleThrowable(currentMicroservicesRegistry, targetException, carbonCallback, request);
                }
                catch (Throwable t) {
                    this.handleThrowable(currentMicroservicesRegistry, t, carbonCallback, request);
                }
                finally {
                    MSF4JResponse.clearBaseUri();
                    carbonMessage.release();
                }
            } else if ("ws".equalsIgnoreCase(protocolName)) {
                EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
                PatternPathRouter.RoutableDestination<Object> routableEndpoint = null;
                Session session = (Session)carbonMessage.getProperty("WEBSOCKET_SERVER_SESSION");
                String uri = (String)carbonMessage.getProperty("TO");
                try {
                    routableEndpoint = endpointsRegistry.getRoutableEndpoint(uri);
                    this.dispatchWebSocketMethod(routableEndpoint, carbonMessage, carbonCallback);
                }
                catch (WebSocketEndpointAnnotationException e) {
                    this.handleError(e, routableEndpoint, session);
                }
            } else {
                log.error("Cannot find the protocol to dispatch.");
            }
        });
        return true;
    }

    private void setBaseUri(Request request) {
        StringBuilder builder = new StringBuilder();
        builder.append(request.getProperty("PROTOCOL").toString().toLowerCase(Locale.US)).append("://").append(request.getHeader("HOST"));
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append("/");
        }
        try {
            MSF4JResponse.setBaseUri(new URI(builder.toString()));
        }
        catch (URISyntaxException e) {
            log.error("Error while setting the Base URI. " + e.getMessage(), e);
        }
    }

    private void dispatchMethod(MicroservicesRegistryImpl registry, Request request, Response response) throws Exception {
        HttpUtil.setConnectionHeader(request, response);
        PatternPathRouter.RoutableDestination<HttpResourceModel> destination = registry.getMetadata().getDestinationMethod(request.getUri(), request.getHttpMethod(), request.getContentType(), request.getAcceptTypes());
        HttpResourceModel resourceModel = destination.getDestination();
        request.setProperty("method", resourceModel.getMethod());
        response.setMediaType(Util.getResponseType(request.getAcceptTypes(), resourceModel.getProducesMediaTypes()));
        HttpMethodInfoBuilder httpMethodInfoBuilder = new HttpMethodInfoBuilder().httpResourceModel(resourceModel).httpRequest(request).httpResponder(response).requestInfo(destination.getGroupNameValues());
        HttpMethodInfo httpMethodInfo = httpMethodInfoBuilder.build();
        if (httpMethodInfo.isStreamingSupported()) {
            Method method = resourceModel.getMethod();
            Class<?> clazz = method.getDeclaringClass();
            if (InterceptorExecutor.executeGlobalRequestInterceptors(registry, request, response) && InterceptorExecutor.executeClassLevelRequestInterceptors(request, response, clazz) && InterceptorExecutor.executeMethodLevelRequestInterceptors(request, response, method)) {
                while (!request.isEmpty() || !request.isEomAdded()) {
                    httpMethodInfo.chunk(request.getMessageBody());
                }
                boolean isResponseInterceptorsSuccessful = InterceptorExecutor.executeMethodLevelResponseInterceptors(request, response, method) && InterceptorExecutor.executeClassLevelResponseInterceptors(request, response, clazz) && InterceptorExecutor.executeGlobalResponseInterceptors(registry, request, response);
                httpMethodInfo.end(isResponseInterceptorsSuccessful);
            }
        } else {
            httpMethodInfo.invoke(destination, request, httpMethodInfo, registry);
        }
    }

    private void handleThrowable(MicroservicesRegistryImpl currentMicroservicesRegistry, Throwable throwable, CarbonCallback carbonCallback, Request request) {
        Optional<ExceptionMapper> exceptionMapper = currentMicroservicesRegistry.getExceptionMapper(throwable);
        if (exceptionMapper.isPresent()) {
            Response msf4jResponse = new Response(carbonCallback, request);
            msf4jResponse.setEntity(exceptionMapper.get().toResponse(throwable));
            msf4jResponse.send();
        } else {
            log.warn("Unmapped exception", throwable);
            carbonCallback.done(HttpUtil.createTextResponse(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Exception occurred :" + throwable.getMessage()));
        }
    }

    private void handleHandlerException(HandlerException e, CarbonCallback carbonCallback) {
        carbonCallback.done(e.getFailureResponse());
    }

    private void dispatchWebSocketMethod(PatternPathRouter.RoutableDestination<Object> routableEndpoint, CarbonMessage carbonMessage, CarbonCallback callback) throws WebSocketEndpointAnnotationException {
        Session session = (Session)carbonMessage.getProperty("WEBSOCKET_SERVER_SESSION");
        if (session == null) {
            throw new IllegalStateException("WebSocket session not found.");
        }
        if (carbonMessage instanceof TextCarbonMessage) {
            TextCarbonMessage textCarbonMessage = (TextCarbonMessage)carbonMessage;
            this.handleTextWebSocketMessage(textCarbonMessage, routableEndpoint, session);
        } else if (carbonMessage instanceof BinaryCarbonMessage) {
            BinaryCarbonMessage binaryCarbonMessage = (BinaryCarbonMessage)carbonMessage;
            this.handleBinaryWebSocketMessage(binaryCarbonMessage, routableEndpoint, session);
        } else if (carbonMessage instanceof StatusCarbonMessage) {
            StatusCarbonMessage statusCarbonMessage = (StatusCarbonMessage)carbonMessage;
            if ("STATUS_OPEN".equals(statusCarbonMessage.getStatus())) {
                String connection = (String)carbonMessage.getProperty("Connection");
                String upgrade = (String)carbonMessage.getProperty("Upgrade");
                if ("Upgrade".equalsIgnoreCase(connection) && "websocket".equalsIgnoreCase(upgrade)) {
                    callback.done(new DefaultCarbonMessage());
                    this.handleWebSocketHandshake(carbonMessage, session);
                }
            } else if ("STATUS_CLOSE".equals(statusCarbonMessage.getStatus())) {
                this.handleCloseWebSocketMessage(statusCarbonMessage, routableEndpoint, session);
            }
        } else if (carbonMessage instanceof ControlCarbonMessage) {
            ControlCarbonMessage controlCarbonMessage = (ControlCarbonMessage)carbonMessage;
            this.handleControlCarbonMessage(controlCarbonMessage, routableEndpoint, session);
        }
    }

    private boolean handleWebSocketHandshake(CarbonMessage carbonMessage, Session session) {
        EndpointsRegistryImpl endpointsRegistry = EndpointsRegistryImpl.getInstance();
        String requestUri = (String)carbonMessage.getProperty("TO");
        PatternPathRouter.RoutableDestination<Object> routableEndpoint = endpointsRegistry.getRoutableEndpoint(requestUri);
        Optional<Method> methodOptional = new EndpointDispatcher().getOnOpenMethod(routableEndpoint.getDestination());
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        try {
            LinkedList parameterList = new LinkedList();
            methodOptional.ifPresent(method -> {
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, routableEndpoint.getDestination(), parameterList, session);
            });
            return true;
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
            return false;
        }
    }

    private void handleTextWebSocketMessage(TextCarbonMessage textCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        Object endpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnStringMessageMethod(endpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam == null) {
                            parameterList.add(textCarbonMessage.getText());
                        } else {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, endpoint, (List<Object>)parameterList, session);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
        }
    }

    private void handleBinaryWebSocketMessage(BinaryCarbonMessage binaryCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnBinaryMessageMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == ByteBuffer.class) {
                        parameterList.add(binaryCarbonMessage.readBytes());
                    } else if (parameter.getType() == byte[].class) {
                        ByteBuffer buffer = binaryCarbonMessage.readBytes();
                        byte[] bytes = new byte[buffer.capacity()];
                        for (int i = 0; i < buffer.capacity(); ++i) {
                            bytes[i] = buffer.get();
                        }
                        parameterList.add(bytes);
                    } else if (parameter.getType() == Boolean.TYPE) {
                        parameterList.add(binaryCarbonMessage.isFinalFragment());
                    } else if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, session);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
        }
    }

    private void handleCloseWebSocketMessage(StatusCarbonMessage closeCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnCloseMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == CloseReason.class) {
                        CloseCodeImpl closeCode = new CloseCodeImpl(closeCarbonMessage.getStatusCode());
                        CloseReason closeReason = new CloseReason(closeCode, closeCarbonMessage.getReasonText());
                        parameterList.add(closeReason);
                    } else if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, session);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
        }
    }

    private void handleControlCarbonMessage(ControlCarbonMessage controlCarbonMessage, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnPongMessageMethod(webSocketEndpoint);
        try {
            methodOptional.ifPresent(method -> {
                LinkedList<Object> parameterList = new LinkedList<Object>();
                Arrays.stream(method.getParameters()).forEach(parameter -> {
                    if (parameter.getType() == PongMessage.class) {
                        parameterList.add(new WebSocketPongMessage(controlCarbonMessage.readBytes()));
                    } else if (parameter.getType() == Session.class) {
                        parameterList.add(session);
                    } else if (parameter.getType() == String.class) {
                        PathParam pathParam = parameter.getAnnotation(PathParam.class);
                        if (pathParam != null) {
                            parameterList.add(paramValues.get(pathParam.value()));
                        }
                    } else {
                        parameterList.add(null);
                    }
                });
                this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, session);
            });
        }
        catch (Throwable throwable) {
            this.handleError(throwable, routableEndpoint, session);
        }
    }

    private void handleError(Throwable throwable, PatternPathRouter.RoutableDestination<Object> routableEndpoint, Session session) {
        Object webSocketEndpoint = routableEndpoint.getDestination();
        Map<String, String> paramValues = routableEndpoint.getGroupNameValues();
        Optional<Method> methodOptional = new EndpointDispatcher().getOnErrorMethod(webSocketEndpoint);
        methodOptional.ifPresent(method -> {
            LinkedList<Object> parameterList = new LinkedList<Object>();
            Arrays.stream(method.getParameters()).forEach(parameter -> {
                if (parameter.getType() == Throwable.class) {
                    parameterList.add(throwable);
                } else if (parameter.getType() == Session.class) {
                    parameterList.add(session);
                } else if (parameter.getType() == String.class) {
                    PathParam pathParam = parameter.getAnnotation(PathParam.class);
                    if (pathParam != null) {
                        parameterList.add(paramValues.get(pathParam.value()));
                    }
                } else {
                    parameterList.add(null);
                }
            });
            this.executeMethod((Method)method, webSocketEndpoint, (List<Object>)parameterList, session);
        });
    }

    private void executeMethod(Method method, Object webSocketEndpoint, List<Object> parameterList, Session session) {
        block10: {
            try {
                if (method.getReturnType() == String.class) {
                    String returnStr = (String)method.invoke(webSocketEndpoint, parameterList.toArray());
                    session.getBasicRemote().sendText(returnStr);
                    break block10;
                }
                if (method.getReturnType() == ByteBuffer.class) {
                    ByteBuffer buffer = (ByteBuffer)method.invoke(webSocketEndpoint, parameterList.toArray());
                    session.getBasicRemote().sendBinary(buffer);
                    break block10;
                }
                if (method.getReturnType() == byte[].class) {
                    byte[] bytes = (byte[])method.invoke(webSocketEndpoint, parameterList.toArray());
                    session.getBasicRemote().sendBinary(ByteBuffer.wrap(bytes));
                    break block10;
                }
                if (method.getReturnType() == Void.TYPE) {
                    method.invoke(webSocketEndpoint, parameterList.toArray());
                    break block10;
                }
                if (method.getReturnType() == PongMessage.class) {
                    PongMessage pongMessage = (PongMessage)method.invoke(webSocketEndpoint, parameterList.toArray());
                    session.getBasicRemote().sendPong(pongMessage.getApplicationData());
                    break block10;
                }
                throw new WebSocketEndpointMethodReturnTypeException("Unknown return type.");
            }
            catch (IllegalAccessException e) {
                log.error("Illegal access exception occurred: " + e.toString());
            }
            catch (InvocationTargetException e) {
                log.error("Method invocation failed: " + e.toString());
            }
            catch (IOException e) {
                log.error("IOException occurred: " + e.toString());
            }
            catch (WebSocketEndpointMethodReturnTypeException e) {
                log.error("WebSocket method return type exception occurred: " + e.toString());
            }
        }
    }

    @Override
    public void setTransportSender(TransportSender transportSender) {
    }

    @Override
    public void setClientConnector(ClientConnector clientConnector) {
    }

    @Override
    public String getId() {
        return MSF4J_MSG_PROC_ID;
    }
}

