/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.util;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class Utils {
    public static String toString(Object object) {
        Objects.requireNonNull(object);
        StringBuilder sb = new StringBuilder();
        try {
            for (Field field : object.getClass().getFields()) {
                sb.append(field.getName()).append(":").append(field.get(object)).append("\n");
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while executing " + object.getClass() + ".toString()", e);
        }
        return sb.toString();
    }

    public static String toString(final Object object, final String[] fields) {
        Objects.requireNonNull(object);
        final StringBuilder sb = new StringBuilder();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    for (String field : fields) {
                        Objects.requireNonNull(field);
                        Field declaredField = object.getClass().getDeclaredField(field);
                        declaredField.setAccessible(true);
                        sb.append(field).append(":").append(declaredField.get(object)).append("\n");
                        declaredField.setAccessible(false);
                    }
                    return sb;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Error while executing " + object.getClass() + ".toString()", e);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("Error while executing " + object.getClass() + ".toString()", e);
                }
            }
        });
        return sb.toString();
    }

    public static List<String> split(String sequence, String delimiter, boolean omitEmpty) {
        Objects.requireNonNull(sequence);
        Objects.requireNonNull(delimiter);
        String[] splittedValues = sequence.split(delimiter);
        List<String> values = Arrays.asList(splittedValues);
        return omitEmpty ? values.stream().filter(value -> !value.isEmpty()).collect(Collectors.toList()) : values;
    }

    public static int getIntersection(Set set1, Set set2) {
        HashSet cloneSet1 = new HashSet(set1);
        HashSet cloneSet2 = new HashSet(set2);
        if (cloneSet1.size() > cloneSet2.size()) {
            cloneSet1.retainAll(cloneSet2);
            return cloneSet1.size();
        }
        cloneSet2.retainAll(cloneSet1);
        return cloneSet2.size();
    }
}

