/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal;

import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportDataHolder;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;

@Component(name="org.wso2.carbon.transport.http.netty.internal.NettyTransportServiceComponent", immediate=true, property={"capability-name=org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer", "component-key=netty-transports-mgt"})
public class NettyTransportServiceComponent
implements RequiredCapabilityListener {
    private static final Logger log = LoggerFactory.getLogger(NettyTransportServiceComponent.class);
    private static final String CHANNEL_ID_KEY = "channel.id";
    private NettyTransportDataHolder dataHolder = NettyTransportDataHolder.getInstance();

    @Activate
    protected void activate(BundleContext bundleContext) {
    }

    @Reference(name="netty-channel.initializer", service=CarbonNettyServerInitializer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeNettyChannelInitializer")
    protected void addNettyChannelInitializer(CarbonNettyServerInitializer initializer, Map<String, ?> properties) {
        try {
            String channelId = (String)properties.get(CHANNEL_ID_KEY);
            if (channelId == null) {
                throw new IllegalArgumentException("channel.id not specified for ChannelInitializer " + initializer);
            }
            this.dataHolder.addNettyChannelInitializer(channelId, initializer);
        }
        catch (Throwable e) {
            log.error("Cannot add CarbonNettyServerInitializer", e);
        }
    }

    protected void removeNettyChannelInitializer(CarbonNettyServerInitializer initializer, Map<String, ?> properties) {
        String channelId = (String)properties.get(CHANNEL_ID_KEY);
        this.dataHolder.removeNettyChannelInitializer(channelId);
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        NettyTransportDataHolder.getInstance().getBundleContext().registerService(NettyTransportServiceComponent.class, (Object)this, null);
        log.info("All CarbonNettyServerInitializers are available");
    }
}

