/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportDataHolder;
import org.wso2.carbon.transport.http.netty.listener.CarbonNettyServerInitializer;
import org.wso2.carbon.transport.http.netty.listener.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.listener.ssl.SSLHandlerFactory;

public class NettyServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(NettyServerInitializer.class);
    private String transportID;
    private SSLConfig sslConfig;

    public NettyServerInitializer(String transportID) {
        this.transportID = transportID;
    }

    public void setSslConfig(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
    }

    @Override
    protected void initChannel(SocketChannel socketChannel) throws Exception {
        CarbonNettyServerInitializer initializer;
        if (this.sslConfig != null) {
            SslHandler sslHandler = new SSLHandlerFactory(this.sslConfig).create();
            socketChannel.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        }
        if ((initializer = NettyTransportDataHolder.getInstance().getChannelInitializer(this.transportID)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Calling CarbonNettyServerInitializer OSGi service " + initializer);
            }
            initializer.initChannel(socketChannel);
        }
    }
}

