/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.base.Defaults;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.beanutils.ConvertUtils;

public final class ParamConvertUtils {
    private static final Map<Class<?>, Method> PRIMITIVES_PARSE_METHODS;

    private ParamConvertUtils() {
    }

    public static Function<String, Object> createPathParamConverter(final Type resultType) {
        if (!(resultType instanceof Class)) {
            throw new IllegalArgumentException("Unsupported @PathParam type " + resultType);
        }
        return new Function<String, Object>(){

            @Override
            public Object apply(String value) {
                return ConvertUtils.convert(value, (Class)resultType);
            }
        };
    }

    public static Function<List<String>, Object> createHeaderParamConverter(Type resultType) {
        return ParamConvertUtils.createListConverter(resultType);
    }

    public static Function<List<String>, Object> createQueryParamConverter(Type resultType) {
        return ParamConvertUtils.createListConverter(resultType);
    }

    private static Function<List<String>, Object> createListConverter(Type resultType) {
        TypeToken<?> typeToken = TypeToken.of(resultType);
        Class<?> resultClass = typeToken.getRawType();
        if (resultClass == String.class) {
            return new BasicConverter(Defaults.defaultValue(resultClass)){

                @Override
                protected Object convert(String value) throws Exception {
                    return value;
                }
            };
        }
        Function<List<String>, Object> converter = ParamConvertUtils.createPrimitiveTypeConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createStringConstructorConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createStringMethodConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createCollectionConverter(typeToken);
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("Unsupported type " + typeToken);
    }

    private static Function<List<String>, Object> createPrimitiveTypeConverter(Class<?> resultClass) {
        Object defaultValue = Defaults.defaultValue(resultClass);
        final Class<?> boxedType = Primitives.wrap(resultClass);
        if (!Primitives.isWrapperType(boxedType)) {
            return null;
        }
        return new BasicConverter(defaultValue){

            @Override
            protected Object convert(String value) throws Exception {
                Method method = (Method)PRIMITIVES_PARSE_METHODS.get(boxedType);
                if (method != null) {
                    return method.invoke(null, value);
                }
                if (boxedType == Character.class) {
                    return Character.valueOf(value.charAt(0));
                }
                return null;
            }
        };
    }

    private static Function<List<String>, Object> createStringConstructorConverter(Class<?> resultClass) {
        try {
            final Constructor<?> constructor = resultClass.getConstructor(String.class);
            return new BasicConverter(Defaults.defaultValue(resultClass)){

                @Override
                protected Object convert(String value) throws Exception {
                    return constructor.newInstance(value);
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Function<List<String>, Object> createStringMethodConverter(Class<?> resultClass) {
        Method method;
        try {
            method = resultClass.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                method = resultClass.getMethod("fromString", String.class);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
        final Method convertMethod = method;
        return new BasicConverter(Defaults.defaultValue(resultClass)){

            @Override
            protected Object convert(String value) throws Exception {
                return convertMethod.invoke(null, value);
            }
        };
    }

    private static Function<List<String>, Object> createCollectionConverter(TypeToken<?> resultType) {
        final Class<?> rawType = resultType.getRawType();
        if (rawType != List.class && rawType != Set.class && rawType != SortedSet.class) {
            return null;
        }
        if (!(resultType.getType() instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType type = (ParameterizedType)resultType.getType();
        if (type.getActualTypeArguments().length != 1) {
            return null;
        }
        Type elementType = type.getActualTypeArguments()[0];
        if (rawType == SortedSet.class && !Comparable.class.isAssignableFrom(TypeToken.of(elementType).getRawType())) {
            return null;
        }
        final Function<List<String>, Object> elementConverter = ParamConvertUtils.createQueryParamConverter(elementType);
        return new Function<List<String>, Object>(){

            @Override
            public Object apply(List<String> values) {
                ImmutableCollection.Builder builder = rawType == List.class ? ImmutableList.builder() : (rawType == Set.class ? ImmutableSet.builder() : ImmutableSortedSet.naturalOrder());
                if (values != null) {
                    for (String value : values) {
                        this.add(builder, elementConverter.apply(ImmutableList.of(value)));
                    }
                }
                return ((ImmutableCollection.Builder)builder).build();
            }

            private <T> void add(ImmutableCollection.Builder<T> builder, Object element) {
                builder.add((T)element);
            }
        };
    }

    static {
        IdentityHashMap<Class<?>, Method> methods = Maps.newIdentityHashMap();
        for (Class<?> wrappedType : Primitives.allWrapperTypes()) {
            try {
                methods.put(wrappedType, wrappedType.getMethod("valueOf", String.class));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        PRIMITIVES_PARSE_METHODS = methods;
    }

    private static abstract class BasicConverter
    implements Function<List<String>, Object> {
        private final Object defaultValue;

        protected BasicConverter(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Object apply(List<String> values) {
            if (values == null || values.isEmpty()) {
                return this.getDefaultValue();
            }
            try {
                return this.convert(values.get(0));
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }

        protected Object getDefaultValue() {
            return this.defaultValue;
        }

        protected abstract Object convert(String var1) throws Exception;
    }
}

