/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messaging;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.BufferFactory;
import org.wso2.carbon.messaging.FaultHandler;
import org.wso2.carbon.messaging.MessageDataSource;
import org.wso2.carbon.messaging.MessageUtil;
import org.wso2.carbon.messaging.Writer;

public abstract class CarbonMessage {
    private static final Logger LOG = LoggerFactory.getLogger(CarbonMessage.class);
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected BlockingQueue messageBody = new LinkedBlockingQueue();
    protected Stack<FaultHandler> faultHandlerStack = new Stack();
    protected MessageDataSource messageDataSource;
    protected ByteBufferInputStream byteBufferInputStream;
    private ByteBufferOutputStream byteBufferOutputStream;
    protected Lock lock = new ReentrantLock();
    protected boolean bufferContent = true;
    protected AtomicBoolean alreadyRead = new AtomicBoolean(false);
    private AtomicBoolean endOfMsgAdded = new AtomicBoolean(false);
    private Writer writer;
    private boolean isMessageBodyAdded;

    public CarbonMessage() {
    }

    public CarbonMessage(Boolean buffercontent) {
        this.bufferContent = buffercontent;
    }

    public void setBufferContent(boolean bufferContent) {
        if (this.isMessageBodyAdded) {
            throw new IllegalStateException("CarbonMessage#setBufferContent cannot be called after adding message body");
        }
        this.bufferContent = bufferContent;
    }

    public boolean isEndOfMsgAdded() {
        return this.endOfMsgAdded.get();
    }

    public boolean isEmpty() {
        return this.messageBody.isEmpty();
    }

    public ByteBuffer getMessageBody() {
        try {
            return (ByteBuffer)this.messageBody.take();
        }
        catch (InterruptedException e) {
            LOG.error("Error while retrieving chunk from queue.", e);
            return null;
        }
    }

    public List<ByteBuffer> getFullMessageBody() {
        ArrayList<ByteBuffer> byteBufferList = new ArrayList<ByteBuffer>();
        while (true) {
            try {
                while (!this.endOfMsgAdded.get() || !this.messageBody.isEmpty()) {
                    byteBufferList.add((ByteBuffer)this.messageBody.take());
                }
            }
            catch (InterruptedException e) {
                LOG.error("Error while getting full message body", e);
                continue;
            }
            break;
        }
        return byteBufferList;
    }

    public void addMessageBody(ByteBuffer msgBody) {
        this.isMessageBodyAdded = true;
        if (this.bufferContent) {
            this.messageBody.add(msgBody);
        } else if (this.writer != null) {
            this.writer.write(msgBody);
        } else {
            LOG.error("Cannot write content no registered writer found");
        }
    }

    public void release() {
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setHeaders(Map<String, String> headerMap) {
        headerMap.forEach(this.headers::put);
    }

    public Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public Stack<FaultHandler> getFaultHandlerStack() {
        return this.faultHandlerStack;
    }

    public void setFaultHandlerStack(Stack<FaultHandler> faultHandlerStack) {
        this.faultHandlerStack = faultHandlerStack;
    }

    public Lock getLock() {
        return this.lock;
    }

    public int getFullMessageLength() {
        List<ByteBuffer> fullMessageBody = this.getFullMessageBody();
        int size = fullMessageBody.stream().mapToInt(byteBuffer -> byteBuffer.limit()).sum();
        fullMessageBody.forEach(byteBuffer -> this.addMessageBody((ByteBuffer)byteBuffer));
        return size;
    }

    public List<ByteBuffer> getCopyOfFullMessageBody() {
        List<ByteBuffer> fullMessageBody = this.getFullMessageBody();
        List<ByteBuffer> newCopy = fullMessageBody.stream().map(byteBuffer -> MessageUtil.deepCopy(byteBuffer)).collect(Collectors.toList());
        fullMessageBody.forEach(byteBuffer -> this.addMessageBody((ByteBuffer)byteBuffer));
        return newCopy;
    }

    public void setEndOfMsgAdded(boolean endOfMsgAdded) {
        this.endOfMsgAdded.compareAndSet(false, endOfMsgAdded);
        if (this.byteBufferOutputStream != null) {
            try {
                this.byteBufferOutputStream.flush();
            }
            catch (IOException e) {
                LOG.error("Exception occured while flushing the buffer", e);
                this.byteBufferOutputStream.close();
            }
        }
        if (this.writer != null) {
            this.writer.writeLastContent(this);
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean isBufferContent() {
        return this.bufferContent;
    }

    public MessageDataSource getMessageDataSource() {
        return this.messageDataSource;
    }

    public void setMessageDataSource(MessageDataSource messageDataSource) {
        this.messageDataSource = messageDataSource;
    }

    public boolean isAlreadyRead() {
        return this.alreadyRead.get();
    }

    public void setAlreadyRead(boolean alreadyRead) {
        this.alreadyRead.set(alreadyRead);
    }

    public InputStream getInputStream() {
        if (this.byteBufferInputStream == null) {
            this.byteBufferInputStream = new ByteBufferInputStream();
        }
        return this.byteBufferInputStream;
    }

    public OutputStream getOutputStream() {
        if (this.byteBufferOutputStream == null) {
            this.byteBufferOutputStream = new ByteBufferOutputStream();
        }
        return this.byteBufferOutputStream;
    }

    protected class ByteBufferOutputStream
    extends OutputStream {
        private ByteBuffer buffer;

        protected ByteBufferOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            if (this.buffer == null) {
                this.buffer = BufferFactory.getInstance().getBuffer();
            }
            if (this.buffer.hasRemaining()) {
                this.buffer.put((byte)b);
            } else {
                this.buffer.flip();
                CarbonMessage.this.addMessageBody(this.buffer);
                this.buffer = BufferFactory.getInstance().getBuffer();
                this.buffer.put((byte)b);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.buffer != null && this.buffer.position() > 0) {
                this.buffer.flip();
                CarbonMessage.this.addMessageBody(this.buffer);
                this.buffer = BufferFactory.getInstance().getBuffer();
            }
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            catch (IOException e) {
                LOG.error("Error while closing output stream but underlying resources are reset", e);
            }
            finally {
                CarbonMessage.this.byteBufferOutputStream = null;
                this.buffer = null;
            }
        }
    }

    protected class ByteBufferInputStream
    extends InputStream {
        private int count;
        private boolean chunkFinished = true;
        private int limit;
        private ByteBuffer byteBuffer;

        protected ByteBufferInputStream() {
        }

        @Override
        public int read() throws IOException {
            CarbonMessage.this.setAlreadyRead(true);
            if (CarbonMessage.this.isEndOfMsgAdded() && CarbonMessage.this.isEmpty() && this.chunkFinished) {
                return -1;
            }
            if (this.chunkFinished) {
                this.byteBuffer = CarbonMessage.this.getMessageBody();
                this.count = 0;
                this.limit = this.byteBuffer.limit();
                if (this.limit == 0) {
                    return -1;
                }
                this.chunkFinished = false;
            }
            ++this.count;
            if (this.count == this.limit) {
                this.chunkFinished = true;
            }
            return this.byteBuffer.get() & 0xFF;
        }
    }
}

