/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.listener;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.transport.http.netty.config.ListenerConfiguration;
import org.wso2.carbon.transport.http.netty.internal.NettyTransportContextHolder;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.message.NettyCarbonMessage;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class WorkerPoolDispatchingSourceHandler
extends SourceHandler {
    private static final Logger log = LoggerFactory.getLogger(WorkerPoolDispatchingSourceHandler.class);
    private ListenerConfiguration listenerConfiguration;

    public WorkerPoolDispatchingSourceHandler(ConnectionManager connectionManager, ListenerConfiguration listenerConfiguration) throws Exception {
        super(connectionManager, listenerConfiguration);
        this.listenerConfiguration = listenerConfiguration;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionInitiation(Integer.toString(ctx.hashCode()));
        }
        this.ctx = ctx;
        this.targetChannelPool = this.connectionManager.getTargetChannelPool();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpMessage) {
            this.publishToWorkerPool(msg);
            ByteBuf content = ((FullHttpMessage)msg).content();
            this.cMsg.addHttpContent(new DefaultLastHttpContent(content));
            if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(this.cMsg);
            }
        } else if (msg instanceof HttpRequest) {
            this.publishToWorkerPool(msg);
        } else if (this.cMsg != null && msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            this.cMsg.addHttpContent(httpContent);
            if (msg instanceof LastHttpContent) {
                this.cMsg.setEndOfMsgAdded(true);
                if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
                    NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestSending(this.cMsg);
                }
            }
        }
    }

    private void publishToWorkerPool(Object msg) {
        ExecutorService executorService = this.listenerConfiguration.getExecutorService();
        this.cMsg = (NettyCarbonMessage)this.setupCarbonMessage(msg);
        if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceRequestReceiving(this.cMsg);
        }
        this.cMsg.setProperty("enable.disruptor", this.listenerConfiguration.getEnableDisruptor());
        this.cMsg.setProperty("executor.workerpool.size", this.listenerConfiguration.getWorkerPoolSize());
        final CarbonCallback carbonCallback = (CarbonCallback)this.cMsg.getProperty("CALL_BACK");
        this.cMsg.setProperty("executor.workerpool", executorService);
        boolean continueRequest = true;
        if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            continueRequest = NettyTransportContextHolder.getInstance().getHandlerExecutor().executeRequestContinuationValidator(this.cMsg, carbonMessage -> {
                CarbonCallback responseCallback = (CarbonCallback)this.cMsg.getProperty("CALL_BACK");
                responseCallback.done(carbonMessage);
            });
        }
        if (continueRequest) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        NettyTransportContextHolder.getInstance().getMessageProcessor().receive(WorkerPoolDispatchingSourceHandler.this.cMsg, carbonCallback);
                    }
                    catch (Exception e) {
                        log.error("Error occurred inside the messaging engine", e);
                    }
                }
            });
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        ctx.close();
        if (NettyTransportContextHolder.getInstance().getHandlerExecutor() != null) {
            NettyTransportContextHolder.getInstance().getHandlerExecutor().executeAtSourceConnectionTermination(Integer.toString(ctx.hashCode()));
        }
        this.connectionManager.notifyChannelInactive();
    }
}

