/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wso2.carbon.messaging.CarbonMessage;

public class Request {
    private final CarbonMessage carbonMessage;
    private List<String> acceptTypes = null;
    private String contentType = null;

    public Request(CarbonMessage carbonMessage) {
        this.carbonMessage = carbonMessage;
        String acceptHeaderStr = carbonMessage.getHeader("Accept");
        this.acceptTypes = acceptHeaderStr != null ? Arrays.asList(acceptHeaderStr.split("\\s*,\\s*")).stream().map(mediaType -> mediaType.split("\\s*;\\s*")[0]).collect(Collectors.toList()) : null;
        String contentTypeHeaderStr = carbonMessage.getHeader("Content-Type");
        this.contentType = contentTypeHeaderStr != null ? contentTypeHeaderStr.split("\\s*;\\s*")[0] : null;
    }

    public boolean isEomAdded() {
        return this.carbonMessage.isEndOfMsgAdded();
    }

    public boolean isEmpty() {
        return this.carbonMessage.isEmpty();
    }

    public ByteBuffer getMessageBody() {
        return this.carbonMessage.getMessageBody();
    }

    public List<ByteBuffer> getFullMessageBody() {
        return this.carbonMessage.getFullMessageBody();
    }

    public Map<String, String> getHeaders() {
        return this.carbonMessage.getHeaders();
    }

    public String getHeader(String key) {
        return this.carbonMessage.getHeader(key);
    }

    public Object getProperty(String key) {
        return this.carbonMessage.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.carbonMessage.getProperties();
    }

    public void setProperty(String key, Object value) {
        this.carbonMessage.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.carbonMessage.removeProperty(key);
    }

    public String getUri() {
        return (String)this.carbonMessage.getProperty("TO");
    }

    public String getHttpMethod() {
        return (String)this.carbonMessage.getProperty("HTTP_METHOD");
    }

    public List<String> getAcceptTypes() {
        return this.acceptTypes;
    }

    public String getContentType() {
        return this.contentType;
    }
}

