/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.transports;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.carbon.kernel.transports.TransportManagerMBean;
import org.wso2.carbon.kernel.utils.Utils;

public class TransportManager
implements TransportManagerMBean {
    private Map<String, CarbonTransport> transports = new HashMap<String, CarbonTransport>();

    public void registerTransport(CarbonTransport transport) {
        this.transports.put(transport.getId(), transport);
    }

    public void unregisterTransport(CarbonTransport transport) {
        this.transports.remove(transport.getId());
    }

    @Override
    public void startTransport(String transportId) {
        CarbonTransport transport = this.transports.get(transportId);
        if (transport == null) {
            throw new IllegalArgumentException(transportId + " not found");
        }
        Utils.checkSecurity();
        transport.startTransport();
    }

    @Override
    public void stopTransport(String transportId) {
        CarbonTransport transport = this.transports.get(transportId);
        if (transport == null) {
            throw new IllegalArgumentException(transportId + " not found");
        }
        Utils.checkSecurity();
        transport.stopTransport();
    }

    @Override
    public void startTransports() {
        Utils.checkSecurity();
        this.transports.values().forEach(CarbonTransport::startTransport);
    }

    @Override
    public void stopTransports() {
        Utils.checkSecurity();
        this.transports.values().forEach(CarbonTransport::stopTransport);
    }

    @Override
    public void beginMaintenance() {
        Utils.checkSecurity();
        this.transports.values().forEach(CarbonTransport::beginTransportMaintenance);
    }

    @Override
    public void endMaintenance() {
        Utils.checkSecurity();
        this.transports.values().forEach(CarbonTransport::endTransportMaintenance);
    }

    @Override
    public Map<String, CarbonTransport> getTransports() {
        Utils.checkSecurity();
        return this.transports;
    }
}

